/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.refactoring.classpath.Util;

/** Encapsulate fields refactoring. This is a composed refactoring (uses instances of {@link org.netbeans.modules.refactoring.api.EncapsulateFieldRefactoring}
 * to encapsulate several fields at once.
 *
 * @author  Pavel Flaska, Jan Becicka
 */
public final class EncapsulateFieldsRefactoring extends AbstractRefactoring {
    
    private Element[] selectedObjects;
    private EncapsulateFieldInfo[] refactorFields;
    private int methodModifier;
    private int fieldModifier;
    private boolean alwaysUseAccessors;

    /** Creates a new instance of EcapsulateFields.
     * @param selectedObjects Array of objects (fields) that should be encapsulated.
     */
    public EncapsulateFieldsRefactoring(Element[] selectedObjects) {
        this.selectedObjects = selectedObjects;
    }
    
    /**
     * Returns array of fields
     * @return array of fields
     */
    public Element[] getFields() {
        if (selectedObjects.length == 1 && selectedObjects[0] instanceof JavaClass) {
            List fields = new ArrayList();
            JavaClass encClass = (JavaClass) selectedObjects[0];
            List features = encClass.getFeatures();
            for (Iterator it = features.iterator(); it.hasNext(); ) {
                Object o = it.next();
                if ((o instanceof Field) && !(o instanceof EnumConstant)) {
                    fields.add(o);
                }
            }
            return (Field[]) fields.toArray(new Field[fields.size()]);
        }
        else return selectedObjects;
    }
    
    protected void setClassPath() {
        Util.setClassPath((Element) selectedObjects[0]);
    }
    
    /**
     * Getter for property refactorFields
     * @return Value of refactorFields
     */
    public EncapsulateFieldInfo[] getRefactorFields() {
        return refactorFields;
    }

    /**
     * Getter for property methodModifier
     * @return Value of methodModifier
     */
    public int getMethodModifier() {
        return methodModifier;
    }

    /**
     * Getter for property fieldModifier
     * @return Value of fieldModifier
     */
    public int getFieldModifier() {
        return fieldModifier;
    }

    /**
     * Getter for property alwaysUseAccessors
     * @return Value of alwaysUseAccessors
     */
    public boolean isAlwaysUseAccessors() {
        return alwaysUseAccessors;
    }
    
    /**
     * Setter for property refactorFields
     * @param refactorFields New value of property refactorFields
     */
    public void setRefactorFields(EncapsulateFieldInfo[] refactorFields) {
        this.refactorFields = refactorFields;
    }

    /**
     * Setter for property methodModifier
     * @param methodModifier New value of property methodModifier
     */
    public void setMethodModifier(int methodModifier) {
        this.methodModifier = methodModifier;
    }

    /**
     * Setter for property fieldModifier
     * @param fieldModifier New value of property fieldModifier
     */
    public void setFieldModifier(int fieldModifier) {
        this.fieldModifier = fieldModifier;
    }

    /**
     * Setter for property alwaysUseAccessors
     * @param alwaysUseAccessors New value of property alwaysUseAccessors
     */
    public void setAlwaysUseAccessors(boolean alwaysUseAccessors) {
        this.alwaysUseAccessors = alwaysUseAccessors;
    }

    /**
     * Getter for property alwaysUseAccessors
     * @return Value of alwaysUseAccessors
     */
    public Element[] getSelectedObjects() {
        return selectedObjects;
    }
    

    ////////////////////////////////////////////////////////////////////////////
    // INNER CLASSES
    ////////////////////////////////////////////////////////////////////////////
    /**
     * Represents data from the panel.
     */
    public static final class EncapsulateFieldInfo {
        Field field;
        String getterName;
        String setterName;
        
        /**
         * Creates an instance of Encapsulate Field Info
         * @param field 
         * @param getterName 
         * @param setterName 
         */
        public EncapsulateFieldInfo(Field field, String getterName, String setterName) {
            this.field = field;
            this.getterName = getterName;
            this.setterName = setterName;
        }
        
        /**
         * Getter for property getterName.
         *
         * @return Value of property getterName.
         */
        public String getGetterName() { return getterName; }
        
        /**
         * Getter for property setterName.
         * 
         * @return Value of property setterName.
         */
        public String getSetterName() { return setterName; }
        
        /**
         * Getter for property field.
         *
         * @return Value of property field.
         */
        public Field getField() { return field; }
        
    }
}
