/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.refactoring.api;

import java.lang.reflect.Modifier;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.javacore.api.JavaModel;

/**
 *
 * @author Tomas Hurka
 */
public class ExtractMethodRefactoring extends AbstractRefactoring {

    private int startOffset;

    private int endOffset;
    // new modifier
    private int modifier;
    // new name
    private String name;
    // table of new parameters
    private ParameterInfo[] paramTable;
    
    private boolean staticMod;
    
    private Resource resource;
    
    private TypeReference returnType;
    
    /** Creates a new instance of ExtractMethodRefactoring */
    public ExtractMethodRefactoring(Resource rsc,int start,int end) {
        resource = rsc;
        startOffset = start;
        endOffset = end;
        modifier = Modifier.PRIVATE;
        name = "newMethod"; // NOI18N
    }

    protected void setClassPath() {
        JavaModel.setClassPath(resource);
    }

    public int getModifier() {
        return modifier;
    }

    public void setModifier(int mod) {
        modifier = mod;
    }

    public String getName() {
        return name;
    }

    public void setName(String n) {
        name = n;
    }

    public ParameterInfo[] getParamTable() {
        return paramTable;
    }

    public void setParamTable(ParameterInfo[] parTable) {
        paramTable = parTable;
    }

    public int getStartOffset() {
        return startOffset;
    }

    public int getEndOffset() {
        return endOffset;
    }

    public Resource getResource() {
        return resource;
    }

    public boolean isStaticMod() {
        return staticMod;
    }

    public void setStaticMod(boolean staticMod) {
        this.staticMod = staticMod;
    }

    public TypeReference getReturnType() {
        return returnType;
    }

    public void setReturnType(TypeReference returnType) {
        this.returnType = returnType;
    }
    
    /**
     * Represents one item for setParameters(List params) list parameter.
     * Item contains information about method parameters.
     */
    public static final class ParameterInfo {
        String name;
        Variable variable;

        /**
         * Creates a new instanceof of ParameterInfo. You have to provide not
         * null values, otherwise it throws an
         * IllegalArgumentException.
         *
         * @param  type       parameter type
         */
        public ParameterInfo(Variable var) {
            if (var == null)
                throw new IllegalArgumentException();
            name = var.getName();
            variable = var;
        }
                
        /**
         * Returns value of the name of parameter. 
         *
         * @return  new name for parameter
         */
        public String getName() { return name; }
        
        public void setName(String n) {
            name = n;
        }

        /**
         * Returns value of the type of parameter.
         *
         * @return new type for parameter
         */
        public Variable getVariable() { return variable; }

    }    
}
