/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.api;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.modules.refactoring.classpath.Util;



/*
 * UseSuperTypeRefactoring.java
 * @author Bharath Ravi Kumar
 * Created on June 20, 2005
 */

/**
 * Replaces the type usages in a project with those
 * of the super type, where applicable
 */
public final class UseSuperTypeRefactoring extends AbstractRefactoring{
    
    private final Element subType;
    private JavaClass superType;
    private boolean searchInComments;
    //Forced to create an array since the ComboBoxModel (for the panel)
    //takes only a vector or an array.
    private JavaClass[] candidateSuperTypes;
    
    /**
     * Creates a new instance of UseSuperTypeRefactoring
     * @param javaClass The class whose occurences must be replaced by
     * that of it's supertype
     */
    //TODO:Check the naming of identifiers
    public UseSuperTypeRefactoring(Element javaClass) {
        subType = javaClass;
        candidateSuperTypes = deriveSuperTypes(subType);
    }
    
    protected void setClassPath() {
        //Just set the complete class path
        Util.setDefaultClassPath();
    }
    
    /**
     * Returns the type whose occurence must be replaced by that of it's supertype.
     * @return The array of elements to be safely deleted
     */
    public Element getTypeElement(){
        return subType;
    }
    
    /**
     * Sets the SuperType to be used by this refactoring
     * @param superClass The SuperType to be used by this refactoring
     */
    public void setTargetSuperType(JavaClass superClass) {
        this.superType = superClass;
    }
    
    /**
     * Returns the SuperType used by this refactoring
     * @return superClass The SuperType used by this refactoring
     */
    public JavaClass getTargetSuperType() {
        return this.superType;
    }
    
    /**
     * Returns the possible SuperTypes that could be used for the initial Type
     * @return The list of possible SuperTypes for the current type
     */
    public JavaClass[] getCandidateSuperTypes(){
        return candidateSuperTypes;
    }
    
    //private helper methods follow
    
    private JavaClass[] deriveSuperTypes(Element subType) {
        if(! (subType instanceof JavaClass))
            return new JavaClass[0];
        
        JavaClass subTypeClass = (JavaClass) subType;
//        Fix for 62854 - an arraylist was used before. But that doesn't intrinsically eliminate
//        duplicates. So, a HashSet is being used now
        HashSet candidateSuperTypeList = new HashSet();
        List interfaceList = subTypeClass.getInterfaces();
        addChangedTypes(candidateSuperTypeList, interfaceList);
        JavaClass tempType = subTypeClass;
        while((tempType = tempType.getSuperClass()) != null){
            //Extract the "non-parameterized" container class for a ParameterizedType
            if(tempType instanceof ParameterizedType)
                tempType = ((ParameterizedType)tempType).getDefinition();
            
            candidateSuperTypeList.add(tempType);
            Collection superInterfaces = tempType.getInterfaces();
            if(superInterfaces != null && superInterfaces.size() > 0)
                addChangedTypes(candidateSuperTypeList, superInterfaces);
        }
        JavaClass[] superTypes = (JavaClass[]) candidateSuperTypeList.toArray(new JavaClass[0]);
        return superTypes;
    }
//    --private helper methods follow--

    /* Checks each JavaClass in the collection that's
     * passed as the second parameter, converts it to a raw type from
     * a ParameterizedType, if necessary, and adds it to the candidateSuperTypesList
     */
    private void addChangedTypes(Collection candidateSuperTypeList, Collection javaClassList) {
        Iterator interfacesIterator = javaClassList.iterator();
        while(interfacesIterator.hasNext()){
            JavaClass superClass = (JavaClass) interfacesIterator.next();
            if(superClass instanceof ParameterizedType)
                superClass = ((ParameterizedType)superClass).getDefinition();
            candidateSuperTypeList.add(superClass);
        }
    }
}