/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.api;

import java.util.Collection;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.refactoring.classpath.Util;

/**
 * Where used query does not do any "real" refactring. I just perform Find Usages
 * @author Martin Matula, Jan Becicka
 */
public final class WhereUsedQuery extends AbstractRefactoring {
    private Object  item;
    private boolean baseClass;
    private boolean overriders;
    private boolean subclasses;
    private boolean directOnly;
    private boolean findUsages=true;
    private boolean searchInComments;

    
    WhereUsedQuery(Object item, AbstractRefactoring caller) {
        this(item);
        this.caller = caller;
    }
    /**
     * Creates a new instance of WhereUsedQuery
     * @param item searched item
     */
    public WhereUsedQuery(Object item) {
        this.item = item;
    }
    
    /**
     * Setter for propety searchFromBaseClass
     * @param searchFromBaseClass New value of property searchFromBaseClass
     */
    public final void setSearchFromBaseClass(boolean searchFromBaseClass) {
        if (!(item instanceof Method)) {
            throw new IllegalStateException();
        }
        this.baseClass = searchFromBaseClass;
    }
    
    /**
     * Setter for propety findOverridingMethods
     * @param findOverridingMethods New value of property findOverridingMethods
     */
    public final void setFindOverridingMethods(boolean findOverridingMethods) {
        if (!(item instanceof Method)) {
            throw new IllegalStateException();
        }
        this.overriders = findOverridingMethods;
    }
    
    /**
     * Setter for propety findUsages
     * @param findUsages New value of property findUsages
     */
    public final void setFindUsages(boolean findUsages) {
        this.findUsages = findUsages;
    }
    
    /**
     * Setter for propety findSubclasses
     * @param findSubclasses New value of property findSubclasses
     */
    public final void setFindSubclasses(boolean findSubclasses) {
        if (!(item instanceof JavaClass)) {
            throw new IllegalStateException();
        }
        this.subclasses = findSubclasses;
    }
    
    /**
     * Setter for propety findDirectSubclassesOnly
     * @param directSubclasses New value of property findDirectSubclassesOnly
     */
    public final void setFindDirectSubclassesOnly(boolean directSubclasses) {
        if (!(item instanceof JavaClass)) {
            throw new IllegalStateException();
        }
        this.directOnly = directSubclasses;
    }
    
    /**
     * Getter for boolean property findUsages
     * @return value of findUsages property
     */
    public final boolean isFindUsages() {
        if (item instanceof JavaClass) {
            return !(subclasses || directOnly);
        } else if (item instanceof Method) {
            return findUsages;
        } else {
            return true;
        }
    }
    
    protected final void setClassPath() {
        if (item instanceof Method) {
            if (isSearchFromBaseClass()) {
                Collection c = JavaModelUtil.getOverriddenMethods((Method) item);
                if (!c.isEmpty()) {
                    Util.setClassPath((Element) c.iterator().next());
                    return;
                }
            }
        }
        Util.setClassPath((Element) item);
    }

    /**
     * Getter for searched item
     * @return searched item (typically JavaClass, Method or Field)
     */
    public final Object getRefactoredObject() {
        return item;
    }    

    /**
     * Getter for boolean property searchFromBaseClass
     * @return Value of property searchFromBaseClass
     */
    public final boolean isSearchFromBaseClass() {
        if (!(item instanceof Method)) {
            throw new IllegalStateException();
        }
        return baseClass;
    }

    /**
     * Getter for boolean property findOverridingMethods
     * @return Value of property findOverridingMethods
     */
    public final boolean isFindOverridingMethods() {
        if (!(item instanceof Method)) {
            throw new IllegalStateException();
        }
        return overriders;
    }

    /**
     * Getter for boolean property findSubclasses
     * @return Value of property findSubclasses
     */
    public final boolean isFindSubclasses() {
        if (!(item instanceof JavaClass)) {
            throw new IllegalStateException();
        }
        return subclasses;
    }
    
    /**
     * Getter for boolean property findDirectSubclassesOnly
     * @return Value of property findDirectSubclassesOnly
     */
    public final boolean isFindDirectSubclassesOnly() {
        if (!(item instanceof JavaClass)) {
            throw new IllegalStateException();
        }
        return directOnly;
    }

    /**
     * Getter for boolean property searchInComments
     * @return Value of property searchInComments
     */
    public final boolean isSearchInComments() {
        return searchInComments;
    }

    /**
     * Getter for boolean property searchInComments
     * @return Value of property searchInComments
     */
    public final void setSearchInComments(boolean searchInComments) {
        this.searchInComments = searchInComments;
    }
    
}
