/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.classpath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Collections;
import org.netbeans.api.java.project.JavaProjectConstants;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;

import org.netbeans.api.java.classpath.GlobalPathRegistryListener;

import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;

import org.openide.util.WeakListeners;




public class RefactoringClassPathImplementation implements ClassPathImplementation, GlobalPathRegistryListener, PropertyChangeListener {

    private List resourceCache;
    private PropertyChangeSupport support;
    private Collection fileSet;

    private RefactoringClassPathImplementation(Collection set) {
        this.support = new PropertyChangeSupport(this);
        this.fileSet = set;
    }

    public synchronized List  getResources() {
        if (this.resourceCache == null) {
            this.resourceCache = Collections.unmodifiableList(this.createResources());
        }
        return this.resourceCache;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener (listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
    
    public void pathsAdded(GlobalPathRegistryEvent event) {
        resetCache();
    }

    
    public void pathsRemoved(GlobalPathRegistryEvent event) {
        resetCache();
    }

    public void propertyChange (PropertyChangeEvent event) {
        resetCache();
    }

    private List createResources () {
        List result = new ArrayList ();
        Set covered = new HashSet ();
        GlobalPathRegistry regs = GlobalPathRegistry.getDefault();
        regs.addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, this, regs));
        assert regs != null : "GlobalPathRegistry.getDefault() returned null";                      //NOI18N
        
        computeDependencies();

        for (Iterator it = sources.iterator(); it.hasNext();) {
            ClassPath cp = (ClassPath) it.next ();
            for (Iterator et = cp.entries().iterator(); et.hasNext();) {
                ClassPath.Entry entry = (ClassPath.Entry) et.next();
                URL url = entry.getURL();
                assert url != null : "ClassPath.Entry.getURL() returned null";        //NOI18N
                if (covered.add (url))
                    result.add (ClassPathSupport.createResource(url));
            }
            cp.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class,this,cp));
        }
        addResources(boot,covered,result);
        addResources(compile,covered,result);
        return result;
    }
    
    private Set sources;
    private Set compile;
    private Set boot;
    
    private void computeDependencies() {
        if (fileSet.isEmpty()) {
            GlobalPathRegistry regs = GlobalPathRegistry.getDefault();
            sources = regs.getPaths(ClassPath.SOURCE);
            assert sources != null : "GlobalPathRegistry.getPath() for SOURCES returned null";          //NOI18N
            compile = regs.getPaths(ClassPath.COMPILE);
            assert compile != null : "GlobalPathRegistry.getPath() for COMPILE returned null";          //NOI18N
            boot = regs.getPaths(ClassPath.BOOT);
            assert boot != null : "GlobalPathRegistry.getPath() for BOOT returned null";                //NOI18N
        } else {
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class,this,OpenProjects.getDefault()));
            
            sources = new HashSet();
            compile = new HashSet();
            boot = new HashSet();
            for (Iterator it = getRelevantProjects().iterator();it.hasNext();) {
                Project p = (Project) it.next();
                Sources src = ProjectUtils.getSources(p);
                SourceGroup[] groups = src.getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA);
                for(int i=0; i<groups.length; i++) {
                    ClassPath cp = ClassPath.getClassPath(groups[i].getRootFolder(), ClassPath.SOURCE);
                    sources.add(cp);
                    cp = ClassPath.getClassPath(groups[i].getRootFolder(), ClassPath.COMPILE);
                    compile.add(cp);
                    cp = ClassPath.getClassPath(groups[i].getRootFolder(), ClassPath.BOOT);
                    boot.add(cp);
                }
            }
        }
    }
    
    private Collection getRelevantProjects() {
        Collection relevantProjects = new HashSet();
        for (Iterator i = fileSet.iterator(); i.hasNext();) {
            FileObject fo = (FileObject) i.next();
            Project p = FileOwnerQuery.getOwner(fo);
            if (p == null) {
                return Arrays.asList(OpenProjects.getDefault().getOpenProjects());
            }
            relevantProjects.addAll(Util.getSuperprojects(p));
            relevantProjects.add(p);
        }
        return relevantProjects;
    }

    private void addResources (Set classPaths, Set coveredResources, List addTo) {
        for (Iterator it = classPaths.iterator(); it.hasNext();) {
            ClassPath cp = (ClassPath) it.next ();
            for (Iterator et = cp.entries().iterator(); et.hasNext();) {
                ClassPath.Entry entry = (ClassPath.Entry) et.next();
                URL url = entry.getURL();
                assert url != null : "ClassPath.Entry.getURL() returned null";        //NOI18N
                if (!isCovered (coveredResources, url)) {
                    addTo.add (ClassPathSupport.createResource(url));
                    coveredResources.add(url);
                }
            }
            cp.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class,this,cp));
        }
    }

    private static boolean isCovered (Set coveredResources, URL url) {
        if (coveredResources.contains(url))
            return true;
        FileObject[] fos = SourceForBinaryQuery.findSourceRoots(url).getRoots();
        assert fos != null : "SourceForBinaryQuery.findSourceRoot() returned null."; // NOI18N
        for (int i=0; i< fos.length; i++) {
            try {
                if (coveredResources.contains(fos[i].getURL())) {
                    return true;
                }
            } catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(e);
            }
        }
        return false;
    }
    
    private void firePropertyChange () {
        this.support.firePropertyChange(PROP_RESOURCES,null,null);
    }
    
    
    public synchronized static ClassPath getDefault () {
        if (defaultInstance == null) {
            defaultInstance = ClassPathFactory.createClassPath(
                new RefactoringClassPathImplementation(Collections.EMPTY_SET));
        }
        return defaultInstance;
    }
    
    public synchronized static ClassPath getCustom(Collection /*<FileObject>*/ set) {
        assert set != null;
        if (customInstance == null || !theSameProjects(set, customInstanceSPI.fileSet)) {
            customInstanceSPI = new RefactoringClassPathImplementation (set);
            customInstance = ClassPathFactory.createClassPath (customInstanceSPI);
        }
        return customInstance;
    }
    
    private static boolean theSameProjects(Collection /*<FileObject>*/ set1, Collection /*<FileObject>*/ set2) {
        if (set1.equals(set2))
            return true;
        HashSet projects1 = getProjects(set1);
        HashSet projects2 = getProjects(set2);
        
        return projects1.equals(projects2);
    }
    
    private static HashSet getProjects(Collection files) {
        HashSet projects = new HashSet(2);
        for (Iterator i = files.iterator(); i.hasNext();) {
            FileObject fo = (FileObject) i.next();
            if (fo!=null) {
                Project p = FileOwnerQuery.getOwner(fo);
                projects.add(p);
            }
        }
        return projects;
    }
    
    private synchronized static void resetCache () {        
        defaultInstance = null;
        customInstance = null;
        Util.resetCache();
    }
    
    private static ClassPath defaultInstance;
    private static ClassPath customInstance;
    private static RefactoringClassPathImplementation customInstanceSPI;

}
