/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.spi;

import java.util.Collection;
import java.util.List;
import org.netbeans.modules.refactoring.SPIAccessor;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;

/**
 *
 * @author Martin Matula
 */
final class AccessorImpl extends SPIAccessor {
    public RefactoringElementsBag createBag(RefactoringSession session, List delegate) {
        assert session != null && delegate != null;
        return new RefactoringElementsBag(session, delegate);
    }
    
    public Collection getReadOnlyFiles(RefactoringElementsBag bag) {
        return bag.getReadOnlyFiles();
    }
}
