/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.refactoring.api.InnerToOuterRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;


/** UI panel for collecting refactoring parameters.
 *
 * @author Martin Matula
 */
public class InnerToOuterPanel extends CustomRefactoringPanel {
    // refactoring this panel provides parameters for
    private final InnerToOuterRefactoring refactoring;
    private final ParametersPanel parent;
    
    /** Creates new form InnerToOuterPanel
     * @param refactoring The refactoring this panel provides parameters for.
     */
    public InnerToOuterPanel(InnerToOuterRefactoring refactoring, final ParametersPanel parent) {
        this.refactoring = refactoring;
        this.parent = parent;
        initComponents();
        setPreferredSize(new Dimension(300, 130));
    }

    /** Initialization of the panel (called by the parent window).
     */
    public void initialize() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                classNameField.setText(refactoring.getClassName());
                if (refactoring.getReferenceName() != null) {
                    fieldNameField.setText(refactoring.getReferenceName());
                    fieldCheckBox.setSelected(true);
                }
                DocumentListener dl = new DocumentListener() {
                    public void changedUpdate(DocumentEvent event) {
                        parent.stateChanged(null);
                    }
                    public void insertUpdate(DocumentEvent event) {
                        parent.stateChanged(null);
                    }
                    public void removeUpdate(DocumentEvent event) {
                        parent.stateChanged(null);
                    }
                };
                classNameField.getDocument().addDocumentListener(dl);
                fieldNameField.getDocument().addDocumentListener(dl);
                classNameField.selectAll();
                classNameField.requestFocusInWindow();
            }
        });
    }
    
    // --- GETTERS FOR REFACTORING PARAMETERS ----------------------------------
    
    /** Getter used by the refactoring UI to get value
     * of target type.
     * @return Target type.
     */
    public String getClassName() {
        return classNameField.getText();
    }
    
    public String getReferenceName() {
        if (fieldCheckBox.isSelected()) {
            return fieldNameField.getText();
        } else {
            return null;
        }
    }

    public void requestFocus() {
        super.requestFocus();
        classNameField.requestFocus();
    }
    
    // --- GENERATED CODE ------------------------------------------------------
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        dataPanel = new javax.swing.JPanel();
        classNameLabel = new javax.swing.JLabel();
        classNameField = new javax.swing.JTextField();
        fieldPanel = new javax.swing.JPanel();
        fieldCheckBox = new javax.swing.JCheckBox();
        fieldNamePanel = new javax.swing.JPanel();
        fieldNameLabel = new javax.swing.JLabel();
        fieldNameField = new javax.swing.JTextField();

        setLayout(new java.awt.BorderLayout());

        setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 11, 11));
        dataPanel.setLayout(new java.awt.BorderLayout(12, 0));

        dataPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        classNameLabel.setLabelFor(classNameField);
        org.openide.awt.Mnemonics.setLocalizedText(classNameLabel, java.util.ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_InnerToOuter_ClassName"));
        dataPanel.add(classNameLabel, java.awt.BorderLayout.WEST);

        dataPanel.add(classNameField, java.awt.BorderLayout.CENTER);
        classNameField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "ACSD_nameField"));
        classNameField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "ACSD_nameField"));

        fieldPanel.setLayout(new java.awt.BorderLayout());

        fieldPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 0, 0, 0));
        org.openide.awt.Mnemonics.setLocalizedText(fieldCheckBox, org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "LBL_InnerToOuter_DeclareField"));
        fieldCheckBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(4, 0, 4, 0));
        fieldCheckBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fieldCheckBoxItemStateChanged(evt);
            }
        });

        fieldPanel.add(fieldCheckBox, java.awt.BorderLayout.NORTH);
        fieldCheckBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "ACSD_DeclareFieldName"));
        fieldCheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "ACSD_DeclareFieldDescription"));

        fieldNamePanel.setLayout(new java.awt.BorderLayout(12, 0));

        fieldNamePanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(4, 32, 0, 0));
        fieldNameLabel.setLabelFor(fieldNameField);
        org.openide.awt.Mnemonics.setLocalizedText(fieldNameLabel, org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "LBL_InnerToOuter_FieldName"));
        fieldNameLabel.setEnabled(false);
        fieldNamePanel.add(fieldNameLabel, java.awt.BorderLayout.WEST);

        fieldNameField.setEnabled(false);
        fieldNamePanel.add(fieldNameField, java.awt.BorderLayout.CENTER);

        fieldPanel.add(fieldNamePanel, java.awt.BorderLayout.SOUTH);

        dataPanel.add(fieldPanel, java.awt.BorderLayout.SOUTH);

        add(dataPanel, java.awt.BorderLayout.NORTH);

    }
    // </editor-fold>//GEN-END:initComponents

    private void fieldCheckBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_fieldCheckBoxItemStateChanged
        boolean enable = evt.getStateChange() == ItemEvent.SELECTED;
        fieldNameField.setEnabled(enable);
        fieldNameLabel.setEnabled(enable);
        parent.stateChanged(null);
    }//GEN-LAST:event_fieldCheckBoxItemStateChanged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField classNameField;
    private javax.swing.JLabel classNameLabel;
    private javax.swing.JPanel dataPanel;
    private javax.swing.JCheckBox fieldCheckBox;
    private javax.swing.JTextField fieldNameField;
    private javax.swing.JLabel fieldNameLabel;
    private javax.swing.JPanel fieldNamePanel;
    private javax.swing.JPanel fieldPanel;
    // End of variables declaration//GEN-END:variables
    
}
