/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.BorderLayout;
import java.io.IOException;
import java.util.*;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.refactoring.classpath.RefactoringClassPathImplementation;
import org.openide.explorer.view.NodeRenderer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.awt.Mnemonics;
import org.openide.util.datatransfer.PasteType;

/**
 * @author Jan Becicka
 */
public class MoveClassesUI implements RefactoringUI, RefactoringUIBypass {
    
    private List resources;
    private Set javaObjects;
    private MovePanel panel;
    private MoveClassRefactoring refactoring;
    private String targetPkgName = "";
    private boolean disable;
    private FileObject targetFolder;
    private PasteType pasteType;
    
    static final String getString(String key) {
        return NbBundle.getMessage(MoveClassUI.class, key);
    }
    
    public MoveClassesUI(Set javaObjects) {
        this(javaObjects, null, null);
    }

    public MoveClassesUI(Set javaObjects, FileObject targetFolder, PasteType paste) {
        this.disable = targetFolder != null;
        this.targetFolder = targetFolder;
        this.javaObjects=javaObjects;
        this.pasteType = paste;
        if (!disable) {
            resources = new ArrayList(javaObjects.size());
            for (Iterator i=javaObjects.iterator(); i.hasNext();) {
                resources.add(JavaModel.getResource(((JavaDataObject) i.next()).getPrimaryFile()));
            }
        }
    }
    
    public String getName() {
        return getString ("LBL_MoveClasses");
    }
     
    public String getDescription() {
        return getName();
    }
    
    public boolean isQuery() {
        return false;
    }
        
    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (panel == null) {
            String pkgName = null;
            if (targetFolder != null) {
                ClassPath cp = ClassPath.getClassPath(targetFolder, ClassPath.SOURCE);
                if (cp != null)
                    pkgName = cp.getResourceName(targetFolder, '.', false);
            }
            panel = new MovePanel (parent, 
                    pkgName != null ? pkgName : getDOPackageName(((DataObject)javaObjects.iterator().next()).getFolder()),
                    getString("LBL_MoveClassesHeadline")
            );
        }
        return panel;
    }
    
    private static String getResPackageName(Resource res) {
        String name = res.getName();
        if ( name.indexOf('/') == -1 )
            return "";
        return name.substring(0, name.lastIndexOf('/')).replace('/','.');
    }
    private static String getDOPackageName(DataObject f) {
        return ClassPath.getClassPath(f.getPrimaryFile(), ClassPath.SOURCE).getResourceName(f.getPrimaryFile(), '.', false);
    }

    private String packageName () {
        return targetPkgName.trim().length() == 0 ? getString ("LBL_DefaultPackage") : targetPkgName.trim ();
    }
    
    private Problem setParameters(boolean checkOnly) {
        if (panel==null) 
            return null;
        targetPkgName = panel.getPackageName ();
        refactoring.setTargetClassPathRoot(panel.getRootFolder());
        refactoring.setTargetPackageName(targetPkgName);
        if (checkOnly) {
            return refactoring.fastCheckParameters();
        } else {
            return refactoring.checkParameters();
        }
    }
    
    public Problem checkParameters() {
        return setParameters(true);
    }
    
    public Problem setParameters() {
        return setParameters(false);
    }
    
    public AbstractRefactoring getRefactoring() {
        if (refactoring == null) {
            if (disable) {
                refactoring = new MoveClassRefactoring(javaObjects, targetFolder);
            } else {
                refactoring = new MoveClassRefactoring (resources);
            }
        }
        return refactoring;
    }

    private final Vector getNodes() {
        Vector result = new Vector(javaObjects.size());
        for(Iterator i = javaObjects.iterator(); i.hasNext();) {
            result.add(((DataObject) i.next()).getNodeDelegate());
        }
        return result;
    }
 
    public boolean hasParameters() {
        return true;
    }
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveClassesUI.class);
    }

    public boolean isRefactoringBypassRequired() {
        return !panel.isUpdateReferences();
    }
    public void doRefactoringBypass() throws IOException {
        pasteType.paste();
    }
    
    
    // MovePanel ...............................................................
    class MovePanel extends MoveClassPanel {
        public MovePanel (final ParametersPanel parent, String startPackage, String headLine) {
            super(parent, startPackage, headLine, targetFolder != null ? targetFolder : ((JavaDataObject) javaObjects.iterator().next()).getPrimaryFile() );
            setCombosEnabled(!disable);
            JList list = new JList(getNodes());
            list.setCellRenderer(new NodeRenderer());
            list.setVisibleRowCount(5);
            JScrollPane pane = new JScrollPane(list);
            bottomPanel.setBorder(new EmptyBorder(8,0,0,0));
            bottomPanel.setLayout(new BorderLayout());
            bottomPanel.add(pane, BorderLayout.CENTER);
            JLabel listOf = new JLabel();
            Mnemonics.setLocalizedText(listOf, NbBundle.getMessage(MoveClassesUI.class, "LBL_ListOfClasses"));
            bottomPanel.add(listOf, BorderLayout.NORTH);
        }
    }
}
