/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.refactoring.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProblemDetails;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

/**
 *
 * @author  Jan Becicka
 */
public class ProblemComponent extends javax.swing.JPanel {
    
    private static Color bgColor =  new Color(240, 240, 240);
    private Problem problem;
    private ProblemDetails details;
    private RefactoringUI ui;
    private static double buttonWidth;
    
    /**
     * Creates new form ProblemComponent 
     */
    public ProblemComponent(Problem problem, RefactoringUI ui) {
        initComponents();
        this.ui = ui;
        icon.setIcon(problem.isFatal()?ErrorPanel.getFatalErrorIcon():ErrorPanel.getNonfatalErrorIcon());
        problemDescription.setText(problem.getMessage());
        this.problem = problem;
        this.details = problem.getDetails();
        //setLightBackground();
        if (details != null) {
            org.openide.awt.Mnemonics.setLocalizedText(showDetails, details.getDetailsHint());
            showDetails.setPreferredSize(new Dimension((int) buttonWidth, (int) showDetails.getMinimumSize().getHeight()));
        } else {
            showDetails.setVisible(false);
        }
        
        validate();
    }
    
    static void initButtonSize(Problem problem) {
        buttonWidth = -1.0;
        while (problem != null) {
            ProblemDetails pdi = problem.getDetails();
            if (pdi != null) {
                buttonWidth = Math.max(new JButton(pdi.getDetailsHint()).getMinimumSize().getWidth(), buttonWidth);
            }
            problem = problem.getNext();
        }
        
    }
    
    public void setLightBackground() {
        setBackground(Color.WHITE);
        problemDescription.setBackground(Color.WHITE);
        icon.setBackground(Color.WHITE);
        //showDetails.setBackground(Color.WHITE);
    }
    
    public void setDarkBackground() {
        Color bgColor =  new Color(240, 240, 240);
        setBackground(bgColor);
        problemDescription.setBackground(bgColor);
        icon.setBackground(bgColor);
        //showDetails.setBackground(bgColor);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        icon = new javax.swing.JLabel();
        problemDescription = new javax.swing.JTextArea();
        showDetails = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3));
        icon.setBackground(javax.swing.UIManager.getDefaults().getColor("TextArea.background"));
        icon.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 6, 1, 6));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(icon, gridBagConstraints);

        problemDescription.setEditable(false);
        problemDescription.setLineWrap(true);
        problemDescription.setWrapStyleWord(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(problemDescription, gridBagConstraints);
        problemDescription.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ProblemComponent.class, "ACSD_ProblemDescriptionName"));
        problemDescription.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ProblemComponent.class, "ACSD_ProblemDescriptionDescription"));

        showDetails.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showDetailsActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(showDetails, gridBagConstraints);
        showDetails.getAccessibleContext().setAccessibleName(showDetails.getText());
        showDetails.getAccessibleContext().setAccessibleDescription(showDetails.getText());

    }
    // </editor-fold>//GEN-END:initComponents

    private void showDetailsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showDetailsActionPerformed
         Container c = this;
         while (!(c instanceof ParametersPanel)) {
             c = c.getParent();
         }
         final ParametersPanel parametersPanel = (ParametersPanel) c;
         Cancellable doCloseParent = new Cancellable() {
             public boolean cancel() {
                 parametersPanel.cancel.doClick();
                 return true;
             }
         };
         ProblemDetails details = problem.getDetails();
         if (details != null) {
             details.showDetails(new CallbackAction(ui), doCloseParent);
         }
    }//GEN-LAST:event_showDetailsActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel icon;
    private javax.swing.JTextArea problemDescription;
    private javax.swing.JButton showDetails;
    // End of variables declaration//GEN-END:variables
    
    private class CallbackAction extends AbstractAction {
        RefactoringUI ui;
        
        public CallbackAction(RefactoringUI ui) {
            super(MessageFormat.format(NbBundle.getMessage(ProblemComponent.class, "LBL_Rerun"), new Object[]{ui.getName()}));
            this.ui = ui;
        }
        
        public void actionPerformed(ActionEvent event) {
            new RefactoringPanel(ui).show();
        }
    }
}
