/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.java.ui.nodes.FilterSourceNodeFactory;
import org.openide.nodes.Node;

/** Filter factory that adds Refactoring action to java element nodes.
 *
 * @author Martin Matula
 */
public class RefactoringFilterFactory extends FilterSourceNodeFactory {
    
    /** Creates a new instance of RefactoringFilterFactory */
    public RefactoringFilterFactory() {
    }
    
    public Node createInitializerNode(Initializer element) {
        return new RefactoringFilterNode(super.createInitializerNode(element));
    }
    
    public Node createFieldNode(Field element) {
        return new RefactoringFilterNode(super.createFieldNode(element));
    }
    
    public Node createConstructorNode(Constructor element) {
        return new RefactoringFilterNode(super.createConstructorNode(element));
    }
    
    public Node createClassNode(JavaClass element) {
        return new RefactoringFilterNode(super.createClassNode(element));
    }
    
    public Node createMethodNode(Method element) {
        return new RefactoringFilterNode(super.createMethodNode(element));
    }
    
    public Node createEnumNode(JavaEnum element) {
        return new RefactoringFilterNode(super.createEnumNode(element));
    }

    public Node createEnumConstantNode(EnumConstant element) {
        return new RefactoringFilterNode(super.createEnumConstantNode(element));
    }

    public Node createAnnotationTypeNode(AnnotationType element) {
        return new RefactoringFilterNode(super.createAnnotationTypeNode(element));
    }

    public Node createAnnotationTypeMethodNode(Attribute element) {
        return new RefactoringFilterNode(super.createAnnotationTypeMethodNode(element));
    }

    public Node createWaitNode() {
        return super.createWaitNode();
    }

    public Node createErrorNode() {
        return super.createErrorNode();
    }
}
