/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.openide.actions.ToolsAction;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.Node.Handle;

/** Filter node that adds Refactoring action to Java element nodes.
 *
 * @author Martin Matula
 */
public class RefactoringFilterNode extends FilterNode {
    private Action refactoringAction = null;
    private Action whereUsedAction = null;
    
    public RefactoringFilterNode(Node original) {
        super(original);
    }
    
    public Node cloneNode() {
        return new RefactoringFilterNode(getOriginal());
    }
    
    public Handle getHandle() {
        Handle origHandle = getOriginal().getHandle();
        // Simplest behavior: just store the original node and try to recreate
        // a filter based on that.
        if (origHandle != null)
            return new RefactoringFilterHandle(origHandle);
        else
            return null; // cannot persist original, do not persist filter
    }

    private static class RefactoringFilterHandle implements Handle {
        private static final long serialVersionUID = 1L;
        private Handle origHandle; // the only serializable state
        public RefactoringFilterHandle(Handle origHandle) {
            this.origHandle = origHandle;
        }
        public Node getNode() throws IOException {
            return new RefactoringFilterNode(origHandle.getNode());
        }
    }
    
    public boolean equals(Object o) {
        return this == o ||
               getOriginal().equals(o) ||
               (o != null && o.equals(getOriginal()));
    }

    public int hashCode() {
        return getOriginal().hashCode();
    }

    public Action[] getActions(boolean context) {
        Action[] orig = super.getActions(context);
        ArrayList ret = new ArrayList(orig.length + 1);
        
        if (refactoringAction == null) {
            refactoringAction = new RefactoringSubMenuAction(false);
            whereUsedAction = (WhereUsedAction) WhereUsedAction.findObject(WhereUsedAction.class, true);
        }
        
        for (int i = 0; i < orig.length; i++) {
            if (orig[i] instanceof ToolsAction) {
                ret.add(whereUsedAction);
                ret.add(refactoringAction);
            }
            if (!(orig[i] instanceof org.openide.actions.RenameAction)) {
                ret.add(orig[i]);
            }
        }

        if (!ret.contains(refactoringAction)) {
            ret.add(refactoringAction);
        }
        
        return (Action[]) ret.toArray(new Action[ret.size()]);
    }    
    
}
