/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.refactoring.ui;

import java.util.Iterator;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

/*
 * UseSuperTypeAction.java
 *
 * Created on June 20, 2005
 * @author Bharath Ravikumar
 */
/**
 * The Action class for the use super type refactoring
 */
public class UseSuperTypeAction extends AbstractRefactoringAction {
    
    /** Creates a new instance of UseSuperTypeAction */
    public UseSuperTypeAction() {
        super(NbBundle.getMessage(UseSuperTypeAction.class, "LBL_UseSuperType_Action"), null); // NOI18N
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    /**
     * Inidicates whether the refactoring action must be enabled
     * for a particular selection.
     * @param activatedNodes The active, selected nodes on which this refactoring
     * will be invoked.
     * @return A boolean indicating whether the refactoring must be
     * enabled.
     */
    protected boolean enabled(org.openide.nodes.Node[] activatedNodes) {
        if(activatedNodes.length != 1)
            return false;
        DataObject dobj = (DataObject) activatedNodes[0].getCookie(DataObject.class);
        //Copied from SafeDelete refactoring
        // Check if the dataobject is instance of JavaDataObejct and that it represents a file
        // that is on the IDE classpath (belongs to one of open projects)
        if ((dobj instanceof JavaDataObject) && ((JMManager) JavaMetamodel.getManager()).mergedCPContains(dobj.getPrimaryFile())) {
            // Check whether the node is associated with the selected DataObject
            if (!dobj.equals(activatedNodes[0].getCookie(DataObject.class))) {
                return false;
            }
        }
        
        Element element = (Element) activatedNodes[0].getLookup().lookup(Element.class);
        return element != null || dobj instanceof JavaDataObject;
    }
    
    /**
     * Instantiates a new refactoring instance given the selected
     * elements and nodes.
     * @param nodes The selected nodes
     * @param selElement The selected element
     * @return The RefactoringUI specific to this refactoring
     */
    protected org.netbeans.modules.refactoring.spi.ui.RefactoringUI createRefactoringUI(org.openide.nodes.Node[] nodes, org.netbeans.jmi.javamodel.Element selElement) {
        Element selectedElement = null;
        
        if(selElement != null)
            selectedElement = selElement;
        else {
            selectedElement = (Element) nodes[0].getLookup().lookup(Element.class);
            if(selectedElement == null) {
                JavaDataObject o = (JavaDataObject) nodes[0].getCookie(DataObject.class);
                Resource cr = org.netbeans.modules.javacore.api.JavaModel.getResource(o.getPrimaryFile());
                selectedElement = null;
                if (cr != null) {
                    for (Iterator it = cr.getClassifiers().iterator(); it.hasNext();) {
                        Object obj = it.next();
                        if (obj instanceof JavaClass) {
                            JavaClass cls = (JavaClass) obj;
                            //Get only the public class defined in the .java file
                            if (nodes[0].getName().equals(cls.getSimpleName())) {
                                selectedElement = cls;
                                break;
                            }
                        }
                    }
                }
            }
        }
        if(selectedElement instanceof ElementReference)
            selectedElement = ((ElementReference) selectedElement).getElement();
        if(selectedElement instanceof Field)
            selectedElement = ((Field) selectedElement).getType();
        else if (selectedElement instanceof Constructor){
            selectedElement = ((Constructor) selectedElement).getDeclaringClass();
        } else if (selectedElement instanceof ParameterizedType){
            selectedElement = ((ParameterizedType) selectedElement).getDefinition();
        }
        
        return new UseSuperTypeRefactoringUI(selectedElement);
    }
    
}
