/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Matula
 */
public class WhereUsedAction extends AbstractRefactoringAction {
    public WhereUsedAction() {
        super(NbBundle.getMessage(WhereUsedAction.class, "LBL_WhereUsedAction"), null);
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    protected RefactoringUI createRefactoringUI(Node[] nodes, org.netbeans.jmi.javamodel.Element selectedElement) {
        RefObject representedObject = selectedElement;
        
        if (representedObject != null) {
            if (representedObject instanceof ElementReference) {
                representedObject = ((ElementReference)representedObject).getElement();
            }
         }
        else {
            Node selNode = nodes[0];
            representedObject = (Element) selNode.getLookup().lookup(Element.class);

            if (representedObject == null) {
                JavaDataObject o = (JavaDataObject) selNode.getCookie(DataObject.class);            
                Resource cr = org.netbeans.modules.javacore.api.JavaModel.getResource(o.getPrimaryFile());
                representedObject = null;
                if (cr != null) {
                    for (Iterator it = cr.getClassifiers().iterator(); it.hasNext();) {
                        Object obj = it.next();
                        if (!(obj instanceof JavaClass))
                            continue;
                        JavaClass cls = (JavaClass) obj;
                        if (selNode.getName().equals(cls.getSimpleName())) {
                            representedObject = cls;
                            break;
                        }
                    }
                }
            }
        }
        return new WhereUsedQueryUI(representedObject);
    }
    
    protected boolean enabled(org.openide.nodes.Node[] activatedNodes) {
        if (activatedNodes.length != 1) return false;
        DataObject dobj = (DataObject) activatedNodes[0].getCookie(DataObject.class);
        if (dobj!=null)
            if (!((JMManager) JMManager.getManager()).mergedCPContains(dobj.getPrimaryFile()))
                return false;

        Element el = (Element) activatedNodes[0].getLookup().lookup(Element.class);

        return el != null || dobj instanceof JavaDataObject;
    }
}
