/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.refactoring.extractsuperclass;

import java.io.IOException;
import java.util.Collections;
import javax.swing.text.BadLocationException;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.refactoring.api.ExtractSuperClassRefactoring;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.test.refactoring.Utility;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;

/**
 *
 * @author Jan Becicka
 */
public class ExtractSuperclassTest extends NbTestCase {
    
    private JavaClass clazz;
    JavaModelPackage pkg;
    public ExtractSuperclassTest() {
        super("ExtractSuperclassTest");
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.extractsuperclass.Impl");
        pkg = (JavaModelPackage) clazz.refOutermostPackage();
    }
    
    public void testExtractInterface() throws FileStateInvalidException, IOException, BadLocationException {
        // initialize refactoring and set parameters
        ExtractSuperClassRefactoring refactoring = new ExtractSuperClassRefactoring(clazz);
        refactoring.setSuperClassName("NewClass");
        Method m = clazz.getMethod("beep", Collections.EMPTY_LIST, false);
        ExtractSuperClassRefactoring.MemberInfo[] members = new ExtractSuperClassRefactoring.MemberInfo[] {new ExtractSuperClassRefactoring.MemberInfo(m, false)};        
        refactoring.setMembers(members);

        // we don't expect any problems from checkParameters
        assertNull(refactoring.checkParameters());
        
        RefactoringSession result = RefactoringSession.create("Extract Superclass NewClass");
        // we don't expect any problems from prepare
        assertNull(refactoring.prepare(result));
        
        // we don't expect any problems during refactoring
        assertNull(result.doRefactoring(true));

        // let's check if all files were correctly refactored
        assertFiles();
    }
    
    // put your test sources into test project: refactoring/test/unit/data/projects/default/src/..
    // test project including your files will be available for refactoring during test execution
    private static final String FILE1 = "org/netbeans/test/extractsuperclass/NewClass.java";
    private static final String FILE2 = "org/netbeans/test/extractsuperclass/Impl.java";
    
    public void assertFiles() throws FileStateInvalidException, IOException, BadLocationException {
        JavaClass cl = Utility.findClass("org.netbeans.test.extractsuperclass.NewClass");
        DataObject dob = ((JMManager) JMManager.getManager()).getDataObject(cl.getResource());
        EditorCookie ec = (EditorCookie) dob.getCookie(EditorCookie.class);
        javax.swing.text.StyledDocument doc=ec.openDocument();
        String str = doc.getText(0,doc.getLength());
        doc.remove(0, str.indexOf("*/")+2);
        str = doc.getText(0,doc.getLength());
        doc.remove(str.indexOf("/*"), str.indexOf("*/")-str.indexOf("/*")+2);
        ((SaveCookie) dob.getCookie(SaveCookie.class)).save();
        

        assertFile(Utility.getFile(getDataDir(), FILE1), getGoldenFile("NewClass.pass"), getWorkDir());    
        assertFile(Utility.getFile(getDataDir(), FILE2), getGoldenFile("Impl.pass"), getWorkDir());    
    }
    
}
