/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.refactoring.safedelete;

import java.io.IOException;
import java.util.Collections;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.test.refactoring.Utility;
import org.openide.filesystems.FileStateInvalidException;


/*
 * @author Bharath Ravikumar
 */
public class SafeDeleteRefactoringTest extends NbTestCase{
    
    private JavaClass referringClass;
    private JavaClass referredClass;
    private static final String TARGET_FILE = "org/netbeans/test/safedelete/ReferredClass.java";
    /**
     * Creates a new instance of SafeDeleteRefactoringTest
     */
    public SafeDeleteRefactoringTest() {
        super("SafeDeleteRefactoringTest");
    }
    
    protected void setUp(){
        referredClass = Utility.findClass("org.netbeans.test.refactoring.safedelete.ReferredClass");
        referringClass = Utility.findClass("org.netbeans.test.refactoring.safedelete.ReferringClass");
    }
    
    public void testSafeDeleteMethod() throws FileStateInvalidException, IOException {
        Method referredMethod = referredClass.getMethod("newMethod", Collections.EMPTY_LIST, false);
        SafeDeleteRefactoring refactoringReferredClass = new SafeDeleteRefactoring(new Element[]{referredMethod});
        
        Method referringMethod = referringClass.getMethod("referringMethod", Collections.EMPTY_LIST, false);
        SafeDeleteRefactoring refactoringReferringClass = new SafeDeleteRefactoring(new Element[]{referringMethod});
        RefactoringSession result = null;
        assertNull(refactoringReferredClass.checkParameters());
        result = RefactoringSession.create("SafeDelete Referred Method");
        assertNotNull(refactoringReferredClass.prepare(result));
        
        //The referring class has no references. Hence, there must be no problem instance returned
        assertNull(refactoringReferringClass.checkParameters());
        result = RefactoringSession.create("SafeDelete Referring Method");
        assertNull(refactoringReferringClass.prepare(result));
        assertNull(result.doRefactoring(true));
        
        //Now that the referring method of the referring class has been removed,
        //we expect no trouble.
        //Compare the refactored class with the golden files
        result = RefactoringSession.create("SafeDelete Referred Method");
        refactoringReferringClass = new SafeDeleteRefactoring(new Element[]{referredMethod});
        refactoringReferredClass.checkParameters();
        assertNull(refactoringReferredClass.prepare(result));
        assertNull(result.doRefactoring(true));
        compareGoldenFile("ReferredClass.pass");
    }
    
    /**
     * Compares the partially refactored file (without referredMethod references) with the golden files
     * using utility methods from {@link org.netbeans.junit.NbTestCase}
     */
    public void compareGoldenFile(String goldenFileName) throws FileStateInvalidException, IOException {
        assertFile(Utility.getFile(getDataDir(), TARGET_FILE), getGoldenFile(goldenFileName), getWorkDir());
    }
//"FinalReferredClass.pass"
}
