/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * Signature1Test.java
 *
 * Created on January 15, 2004, 11:53 AM
 */

package org.netbeans.test.refactoring.signature;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.StyledDocument;
import junit.textui.TestRunner;
import org.netbeans.modules.refactoring.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.api.ChangeParametersRefactoring.ParameterInfo;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.junit.AssertionFailedErrorException;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.refactoring.Utility;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;

/**
 *
 * @author  Pavel Flaska
 */
public class Signature1Test extends NbTestCase {
    
    // filetable is filed by initializer - contain pairs of names for
    // comparing results - second index value 0 represents generated file,
    // second index value 1 represents golden file.
    static String[][] filetable;
    
    static {
        // init filetable
        final String[] filename = { 
            "Signature1Owner",
            "Signature1User1",
            "Signature1User2",
            "Signature1User3"
        };
        final String prefix = "org/netbeans/test/signature/";
        filetable = new String[4][2];
        for (int i = 0; i < 4; i++) {
            filetable[i][0] = prefix + filename[i] + ".java";
            filetable[i][1] = filename[i] + ".pass";
        }
    };
    
    /** Creates a new instance of Signature1Test */
    public Signature1Test() {
        super("Signature1Test");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(Signature1Test.class);
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    Method sigMethod;
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.signature.Signature1Owner");
        pkg = (JavaModelPackage) clazz.refOutermostPackage();
        // get a method which signature will be changed
        sigMethod = (Method) clazz.getFeatures().get(1);
    }
    
    public void testAddParameter() throws FileStateInvalidException, IOException {
        // initializer new table for parameters
        ParameterInfo newPar = new ParameterInfo(-1, "aNewParameter", pkg.getType().resolve("int"), "55");
        List origPars = sigMethod.getParameters();
        ParameterInfo[] aParamTable = new ParameterInfo[origPars.size()+1];
        for (int i = 0; i < aParamTable.length; i++) {
            aParamTable[i] = new ParameterInfo(i, null, null, null);
        }
        aParamTable[aParamTable.length-1] = newPar;
        // initialize refactoring
        ChangeParametersRefactoring refactoring = new ChangeParametersRefactoring(sigMethod);
        refactoring.preCheck();
        refactoring.setParameterInfo(aParamTable);
        refactoring.setModifiers(Modifier.PUBLIC);
        refactoring.checkParameters();
        RefactoringSession result = RefactoringSession.create("change method signature");
        refactoring.prepare(result);
        result.doRefactoring(true);
        assertFiles();
    }
    
//    File getFile(String name) throws FileStateInvalidException {
//        String result = convertNBFSURL(Repository.getDefault().findResource(name).getURL());
//        //getLog(name.substring(name.lastIndexOf('/'))).print(Utility.getAsString(name));
//        return new File(result);
//    }

    public void assertFiles() throws FileStateInvalidException, IOException {
        // assert all affected files
        for (int i = 0; i < 4; i++) {
            assertFile(Utility.getFile(getDataDir(), filetable[i][0]), getGoldenFile(filetable[i][1]), getWorkDir());
        }
    }
    
    /**
     * Creates original parameter table and allocates the extraspace in array
     * for the new parameters (provided by additionalSize parameter)
     *
     * @param  method  Method to be changed
     * @param  additionalSize number of the new param for which you want 
     *                        to allocate memory
     * @return array, every item represents list containing name, type, 
     *         default value (only for the new parameter)
     */
    // not used - should be removed
    private Object[] createOriginalParTable(CallableFeature method, int additionalSize) {
        List origParams = method.getParameters();
        Object[] parameters = new Object[origParams.size() + additionalSize];
        int pos = 0;
        for (Iterator paramsIt = origParams.iterator(); paramsIt.hasNext(); pos++) {
            Parameter par = (Parameter) paramsIt.next();
            List singlePar = new ArrayList();
            
            singlePar.add(par.getName());
            singlePar.add(par.getType().getName());
            singlePar.add("");
            singlePar.add(new Integer(pos));
            
            parameters[pos] = singlePar;
        }
        return parameters;
    }
    
    public static String getAsString(String file) {
        String result;
        try {
            FileObject testFile = Repository.getDefault().findResource(file);
            DataObject dob = DataObject.find(testFile);
            
            EditorCookie ec = (EditorCookie) dob.getCookie(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            result = doc.getText(0, doc.getLength());
        } 
        catch (Exception e) {
            throw new AssertionFailedErrorException(e);
        }
        return result;
    }
    
}
