/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.refactoring.usesupertype;

import java.io.IOException;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.UseSuperTypeRefactoring;
import org.netbeans.test.refactoring.Utility;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author Bharath Ravikumar
 * NOTE:This class will not test for covariant return types for now. We need a 1.5 compliant project to do that.
 */
public class UseSuperTypeTest extends NbTestCase
{
    private static final String TARGET_FILE = "org/netbeans/test/usesupertype/NewClass.java";
    private JavaClass newClass1;
    private JavaClass newClassSuper;
    private JavaClass newClassMid;
    /**
     * Creates a new instance of UseSuperTypeTest
     */
    public UseSuperTypeTest() {
        super("UseSuperTypeTest");
    }
    
    public void testUseSuperType() throws FileStateInvalidException, IOException {
        UseSuperTypeRefactoring useSuperType = new UseSuperTypeRefactoring(newClass1);
        useSuperType.setTargetSuperType(newClassSuper);
        RefactoringSession result = RefactoringSession.create("UseSupertype Test");
        assertNull(useSuperType.checkParameters());
        assertNull(useSuperType.prepare(result));
        assertEquals(result.getRefactoringElements().size(), 0);
        useSuperType.setTargetSuperType(newClassMid);
        assertNull(useSuperType.prepare(result));
        assertTrue(result.getRefactoringElements().size() > 0);
        result.doRefactoring(true);
        assertFile(Utility.getFile(getDataDir(), TARGET_FILE), getGoldenFile("NewClassFinal.pass"), getWorkDir());
    }

    protected void setUp() throws Exception {
        newClass1 = Utility.findClass("org.netbeans.test.refactoring.usesupertype.NewClass1");
        newClassSuper = Utility.findClass("org.netbeans.test.refactoring.usesupertype.NewClassSuper");
        newClassMid = Utility.findClass("org.netbeans.test.refactoring.usesupertype.NewClassMid");
    }
}
