/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.schema2beansdev;

import java.io.*;
import java.util.*;

import org.netbeans.modules.schema2beans.*;
import org.netbeans.modules.schema2beansdev.metadd.*;

public interface CodeGeneratorClass {
    /**
     *	This method is called by the BeanBuilder to register a new property
     *	on this bean class.
     */
    AbstractCodeGeneratorClass.Property addProperty(String name,
                     String dtdName, String namespace,
                     GraphNode node, GraphLink l, String classType, int nestedLevel,
                     int eltInstance, int groupInstance,
                     int type, boolean ored, AttrProp[] propAttributes,
                     String constName, String defaultValue,
                     boolean directChild, List extraData, boolean isUnion);
    List/*<AbstractCodeGeneratorClass.Property>*/ getPropertyList();

    void setPackageName(String n);

    /**
     * The string that is used for indentation.
     */
    void setIndent(String indent);

    /**
     *	Generate the java code in the out stream, using the optional
     *	metaDD bean graph.
     */
    void generate(String filename, MetaDD mdd) throws IOException;

    /**
     *	Generate the java code in the out stream, using the optional
     *	metaDD bean graph.
     */
    void generate(OutputStream out, MetaDD mdd) throws IOException;

    public void generateDelegator(OutputStream out, MetaDD mdd,
                                  String delegatorClassName,
                                  String delegatorPackageName) throws IOException;

    /**
     * The generator should put in an entry for every name that is
     * invalid to use as a property name.
     *
     * @param invalidNames is a
     * Map<String, BeanElement> where they key is the invalid name and
     * the value (BeanElement) is most likely null.
     * For instance, anything that inherits from java.lang.Object will
     * not be able to generate a getClass method, so the property
     * named "Class" is invalid.
     * Typically, the invalid method names are due to a parent class
     * already having a method of that name with the same parameters
     * (overloading is okay though).  A property X is invalid if a
     * parent class already has a getX(); and if X might
     * ever be an array, then also getX(int) or sizeX().
     */
    public void setInvalidPropertyNames(Map invalidNames);
    
    public void setRootBeanElement(BeanBuilder.BeanElement element);

    /**
     * Set the namespace that will be used by default in the documents.
     */
    public void setDefaultNamespace(String ns);

    public Collection getGeneratedMethods();	// Collection<JavaWriter.Method>

    /**
     * Print out the bean graph.
     */
    public void dumpBeanTree(java.io.Writer out, String indent, String indentBy) throws java.io.IOException;
    
    public void setPrefixGuesser(PrefixGuesser guesser);
}
