/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.schema2beansdev;

import java.beans.*;
import java.io.*;

public class TestListener implements PropertyChangeListener {
    public PrintStream out;
    public boolean printStackTrace;

    public TestListener(PrintStream out) {
        this.out = out;
    }

    public void propertyChange(PropertyChangeEvent e) {
        out.print("oldValue=");
        printValue(e.getOldValue());
        out.println();
        out.print("newValue=");
        printValue(e.getNewValue());
        out.println();
        out.println("propertyName="+e.getPropertyName());
        out.println("source="+e.getSource());
        if (printStackTrace) {
            new Exception().printStackTrace();
        }
    }

    public void printValue(Object v) {
        if (v == null) {
            out.print("null");
            return;
        }
        Class cls = v.getClass();
        if (cls.isArray()) {
            out.print("{");
            Object[] arr = (Object[]) v;
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0)
                    out.print(", ");
                printValue(arr[i]);
            }
            out.print("}");
        } else {
            out.print(""+v);
        }
    }
}
