/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.schema2beansdev;

import java.util.*;
import java.io.*;


/**
 *
 *  Methods used by the bean builder to access the DTD object graph nodes.
 *  This interface is implemented by the TreeBuilder and used by the class
 *  BeanBuilder.
 *
 */
public interface TreeParser {
    /**
     *	Return the list of all the GraphNode objects of the DTD object graph.
     */
    public GraphNode[] getNodes();
    
    /**
     *	Return a specific GraphNode.
     */
    public GraphNode getNode(String name);
    
    /**
     *	Return the root of the DTD object graph.
     */
    public GraphNode getRoot();

    /**
     * Get the namespace that will be used by default in the documents.
     */
    public String getDefaultNamespace();
}
