/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 *	TestBadNames - test some bad names
 *
 */

import java.io.*;
import java.util.*;
import org.w3c.dom.*;

import badnames.*;


public class TestBadNames extends BaseTest {
    public static void main(String[] argv) {
        TestBadNames o = new TestBadNames();
        if (argv.length > 0)
            o.setDocumentDir(argv[0]);
        try {
            o.run();
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
    
    public void run() throws Exception {
        BadNames bn;

        this.readDocument();

        out("creating the bean graph");
        bn = BadNames.createGraph(doc);

        //	Check that we can read the graph and it is complete
        out("bean graph created");
        bn.write(out);

        out(bn);
        out(bn.dumpBeanNode());
        ElT e = bn.getElT();
        // This ought not to be null, but is.
        out("e="+e);

        e = bn.newElT();
        bn.setElT(e);
        out(bn.dumpBeanNode());
        e.setProperty2(0);
        e.setPackage("5");
        e.setClass2("other c");
        bn.write(out);
    }
}
