/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 *	TestFind - test the find feature
 *
 *	Search property value, attribute value and any value.
 *
 */

import java.io.*;
import java.util.*;
import org.w3c.dom.*;

import org.netbeans.modules.schema2beans.*;

import java.beans.*;

import book.*;


public class TestFind extends BaseTest
{
    public static void main(String[] argv) {
        BaseTest o = new TestFind();
        if (argv.length > 0)
            o.setDocumentDir(argv[0]);
        try {
            o.run();
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
    
	
	public void run()
		throws Exception
	{
		Book b1, b2, b3;

		this.readDocument();
		out("creating the bean graph");
		Book book = Book.createGraph(doc);

		//GraphManager.debug(true);
		//	Check that we can read the graph an it is complete
		out("bean graph created");

		//
		//	Find property value
		//
		setTest("Test findProperty -");
		String []r = book.findPropertyValue("Word", "Good book");
		check(r.length == 1, "found element");
		if (r.length > 0)
			out(r[0]);
		r = book.findPropertyValue("Line", "31");
		check(r.length == 2, "found elements");
		if (r.length > 1)
		{
			out(r[0]);
			out(r[1]);
		}
		
		r = book.findPropertyValue("Page", "1234");
		check(r.length == 0, "not found element");

		//
		//	Find property and/or attribute value
		//
		setTest("Test findValue -");
		r = book.findValue("31");
		check(r.length == 3, "found elements");
		if (r.length > 2)
		{
			out(r[0]);
			out(r[1]);
			out(r[2]);
		}

		r = book.findValue("E-Tool");
		check(r.length == 1, "found element");
		if (r.length > 0)
		{
			out(r[0]);
		}

		r = book.findValue("this is not in the XML document");
		check(r.length == 0, "not found element");

		r = book.findValue("yes");
		check(r.length == 2, "found elements");
		if (r.length > 1)
		{
			out(r[0]);
			out(r[1]);
		}

		r = book.findValue("no");
		check(r.length == 1, "found element");
		if (r.length > 0)
		{
			out(r[0]);
		}
		
		//
		//	Find attribute value
		//
		setTest("Test findAttributeValue -");
		r = book.findAttributeValue("Color", "red");
		check(r.length == 1, "found element");
		if (r.length > 0)
		{
			out(r[0]);
		}

		//	try with the dtd name (color instead of Color)
		r = book.findAttributeValue("color", "blue");
		check(r.length == 1, "found element");
		if (r.length > 0)
		{
			out(r[0]);
		}

		r = book.findAttributeValue("Color", "black");
		check(r.length == 0, "not found element");
		
		r = book.findAttributeValue("freq", "1");
		check(r.length == 2, "found elements");
		if (r.length > 1)
		{
			out(r[0]);
			out(r[1]);
		}
		
		r = book.findAttributeValue("Good", "no");
		check(r.length == 1, "found element");
		if (r.length > 0)
		{
			out(r[0]);
		}

		//
		//	Try to remove an element by value the by reference
		//
		
	}
}


