/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 *	TestPositions - test the basic features.
 *
 *	The following test assumes that we know the content of the
 *	graph as we get elements, add and change them. Therefore, the TestPositions.xml
 *	file and this java test should be kept in sync.
 *
 * 	Test the following:
 *
 *	single String: get/set/remove/set/get
 *	boolean (from true): get/set true/get/set false/get/set true/get
 *	boolean (from false): get/set false/get/set true/get/set false/get
 *	String[]: get/set (null & !null)/add/remove
 *	Bean: remove/set(null)/create bean and graph of beans/set/add
 *
 */

import java.io.*;
import java.util.*;
import org.w3c.dom.*;

import menus.*;


public class TestPositions extends BaseTest {
    public static void main(String[] argv) {
        TestPositions o = new TestPositions();
        if (argv.length > 0)
            o.setDocumentDir(argv[0]);
        try {
            o.run();
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
    
    public void run() throws Exception {
        Menus menus;

        this.readDocument();

        out("creating the bean graph");
        menus = Menus.read(doc);
	
        //	Check that we can read the graph an it is complete
        out("bean graph created");
        menus.write(out);

        out("Check to make sure that elements with the same name get put into the right spot");
        Foo foo = menus.getFoo();
        check(foo.sizeName() == 2, "There are 2 names");
        check("name2".equals(foo.getName2()), "name2 is in the right spot");
        check("name3".equals(foo.getName3()), "name3 is in the right spot");

        out("Adding some colors to the menu.");
        Menu menu = menus.getMenu(0);
        menu.addMenuItem("red");
        menu.addMenuItem("magenta");
        menu.addMenuItem("blue");
        menu.addSeparator(new Separator());
        menu.addMenuItem("cyan");
        menu.addSeparator(new Separator());
        menu.addMenuItem("green");
        menus.write(out);
        check(8 == menu.sizeMenuItem(), "sizeMenuItem="+menu.sizeMenuItem());
        out(menu.getMenuItem());

        out("Replacing menu items with many numbers");
        menu.setMenuItem(new String[] {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        menus.write(out);

        out("Removing 7");
        menu.removeMenuItem("7");
        menus.write(out);

        out("Replacing menu items with few letters");
        menu.setMenuItem(new String[] {"a", "b", "c"});
        menus.write(out);
    }
}
