/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * ConfigurationSupport.java
 *
 * Created on November 29, 2004, 3:22 PM
 */

package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.File;
import java.util.Set;

import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;

import org.netbeans.modules.j2ee.deployment.common.api.OriginalCMPMapping;
import org.netbeans.modules.j2ee.deployment.plugins.api.ConfigurationSupport;
import org.netbeans.modules.j2ee.sun.share.configbean.EjbJarRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;

/** Implementation of ConfigurationSupport.
 *
 *  Primarily serves to delegate directly to the specified DeploymentConfiguration
 *  instance, as that is in shared code and has appropriate access and this instance
 *  is not.
 *
 */
public class ConfigurationSupportImpl extends ConfigurationSupport {

    /** Creates a new instance of ConfigurationSupport */
    public ConfigurationSupportImpl() {
    }

    
    /** Called by j2eeserver to initialize the deployment configuration object
     *  for this J2EE project.
     */
    public void initConfiguration(DeploymentConfiguration config, File[] files, File resourceDir, boolean keepUpdated) throws ConfigurationException {
        checkConfiguration(config);
        if(files == null || files.length < 1 || files[0] == null) {
            throw new IllegalArgumentException("files[] must be non-null and contain at least one non-null member.");
        }
        ((SunONEDeploymentConfiguration)config).init(files, resourceDir, keepUpdated);
    }    

    
    /** Called by j2eeserver to allow us to cleanup the deployment configuration object
     *  for this J2EE project.
     */
    public void disposeConfiguration(DeploymentConfiguration config) {
        checkConfiguration(config);
        ((SunONEDeploymentConfiguration)config).dispose();
    }

    
    /** Called through j2eeserver when a new resource may need to be added to the
     *  user's project.
     */
    public void ensureResourceDefined(DeploymentConfiguration config, DDBean ddBean) {
        checkConfiguration(config);
        if(ddBean == null) {
            throw new IllegalArgumentException("DDBean parameter cannot be null.");
        }
        ((SunONEDeploymentConfiguration)config).ensureResourceDefined(ddBean);
    }

    /** Called through j2eeserver when a new EJB resource may need to be added to the
     *  user's project.
     */
    public void ensureResourceDefined(DeploymentConfiguration config, DDBean ddBean, String jndiName) {
        checkConfiguration(config);
        if(ddBean == null) {
            throw new IllegalArgumentException("DDBean parameter cannot be null.");
        }
        ((SunONEDeploymentConfiguration)config).ensureResourceDefinedForEjb(ddBean, jndiName);
    }

    
    /** Conduit to pass the cmp mapping information directly to the configuration
     *  backend.
     */
    public void setMappingInfo(DeploymentConfiguration config, OriginalCMPMapping[] mapping){
        checkConfiguration(config);
        SunONEDeploymentConfiguration s1config = (SunONEDeploymentConfiguration) config;
        EjbJarRoot ejbJarRoot = s1config.getEjbJarRoot();
        if(ejbJarRoot != null) {
            ejbJarRoot.mapCmpBeans(mapping);
        }
    }


    /** Retrieves the context root field from sun-web.xml for this module, if the module is a
     *  web application.  Otherwise, returns null.
     */
    public String getWebContextRoot(DeploymentConfiguration config, DeployableObject deplObj) throws ConfigurationException {
        checkConfiguration(config);
        assert config.getDeployableObject() == deplObj;
        return ((SunONEDeploymentConfiguration)config).getContextRoot();
    }

    
    /** Sets the context root field in sun-web.xml for this module, if the module is a
     *  web application.
     */
    public void setWebContextRoot(DeploymentConfiguration config, DeployableObject deplObj, String contextRoot) throws ConfigurationException {
        checkConfiguration(config);
        assert config.getDeployableObject() == deplObj;
        ((SunONEDeploymentConfiguration)config).setContextRoot(contextRoot);
    }
    
    
    /** Updates the resource dir in use by this project.
     */
    public void updateResourceDir(DeploymentConfiguration config, File resourceDir) {
        checkConfiguration(config);
        ((SunONEDeploymentConfiguration) config).updateResourceDir(resourceDir);
    }
    
    /** Utility method to validate the configuration object being passed to the
     *  other methods in this class.
     */
    private void checkConfiguration(DeploymentConfiguration config) {
        if(config == null) {
            throw new IllegalArgumentException("DeploymentConfiguration is null");
        }
        if(!(config instanceof SunONEDeploymentConfiguration)) {
            throw new IllegalArgumentException("Wrong DeploymentConfiguration instance " + config.getClass().getName());
        }
    }
    
    /**
     * Implementation of DS Management API in ConfigurationSupport
     * @param config deployment configuration object for this J2EE project.
     * @return Returns Set of SunDataSource's(JDBC Resources) present in this J2EE project
     * SunDataSource is a combination of JDBC & JDBC Connection Pool Resources.
     */
    public Set getDatasources(DeploymentConfiguration config) {
        checkConfiguration(config);
        SunONEDeploymentConfiguration sunConfig = ((SunONEDeploymentConfiguration)config);
        Set projectDS = sunConfig.getDatasources();
        return projectDS;
    }    
    
    /**
     * Implementation of DS Management API in ConfigurationSupport
     * @return Returns true of plugin implements DS Management API's
     */
    public boolean isDatasourceCreationSupported() {
        return true;
    }
    

    /**
     * Implementation of DS Management API in ConfigurationSupport
     * Creates DataSource objects for this J2EE Project
     * @param config deployment configuration object for this J2EE project.
     * @param jndiName JNDI Name of JDBC Resource
     * @param url Url for database referred to by this JDBC Resource's Connection Pool
     * @param username UserName for database referred to by this JDBC Resource's Connection Pool
     * @param password Password for database referred to by this JDBC Resource's Connection Pool
     * @param driver Driver ClassName for database referred to by this JDBC Resource's Connection Pool
     * @return Set containing SunDataSource
     */
    public Datasource createDatasource(DeploymentConfiguration config, String jndiName, String  url, String username, String password, String driver) 
    throws OperationUnsupportedException, ConfigurationException, DatasourceAlreadyExistsException    {
        checkConfiguration(config);
        SunONEDeploymentConfiguration sunConfig = ((SunONEDeploymentConfiguration)config);
        return sunConfig.createDatasource(jndiName, url, username, password, driver);
    }
    
}

