/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.sun.test;

import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;

/**
 *
 * @author Michal Mocnak
 */
public class EjbModuleTest extends NbTestCase {
    
    private final int SLEEP = 10000;
    
    public EjbModuleTest(String testName) {
        super(testName);
    }
    
    public void deployEjbModule() {
        try {
            Util.deployModule(ModuleType.EJB, Util.EJB_PROJECT_PATH, Util.EJB_PROJECT_NAME);
        } catch(Exception e) {
            fail(e.getMessage());
        }
    }
    
    public void undeployEjbModule() {
        try {
            ServerInstance si = ServerRegistry.getInstance().getServerInstance(Util._URL);
            TargetModuleID moduleID = Util.getModuleID(ModuleType.EJB, Util.EJB_PROJECT_NAME, si);
            
            if(moduleID == null)
                return;
            
            Util.undeployModule(ModuleType.EJB, Util.EJB_PROJECT_PATH, Util.EJB_PROJECT_NAME, moduleID);
        } catch(Exception e) {
            fail(e.getMessage());
        }
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite("EjbModuleTest");
        suite.addTest(new AddRemoveSjsasInstanceTest("addSjsasInstance"));
        suite.addTest(new EjbModuleTest("deployEjbModule"));
        suite.addTest(new EjbModuleTest("undeployEjbModule"));
        suite.addTest(new StartStopServerTest("stopServer"));
        suite.addTest(new AddRemoveSjsasInstanceTest("removeSjsasInstance"));
        return suite;
    }
}
