/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.sun.bridge;

import com.sun.enterprise.admin.jmx.remote.DefaultConfiguration;
import com.sun.enterprise.admin.jmx.remote.SunOneHttpJmxConnectorFactory;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.deployapi.SunDeploymentManager;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.deployment.client.ServerConnectionEnvironment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;

/*
 * wrap some App Server internal APIS calls
 * for the netbeans plugin
 * to compile this class, you need some App Server jar files like appsrv-rt.jar and appsrv-admin.jar
 * @author: Ludovic Champenois
 *
 **/


public class AppServerBridge {
    
    public static    java.io.File getDirLocation( TargetModuleID tmid){
        java.io.File dirLocation=null;
        try{
            SunTargetModuleID ddd = (SunTargetModuleID)tmid;
            
            if (ddd.getModuleType().equals(ModuleType.WAR)){
                ObjectName aaaa = new ObjectName("com.sun.appserv:type=web-module,name="+ddd.getModuleID()+",category=config");
                dirLocation =new java.io.File(""+ddd.getMBeanServerConnection().getAttribute(aaaa,"location"));
                //               System.out.println("dirLocation"+dirLocation);
            } else if (ddd.getModuleType().equals(ModuleType.EJB)){
                ObjectName aaaa = new ObjectName("com.sun.appserv:type=ejb-module,name="+ddd.getModuleID()+",category=config");
                dirLocation =new java.io.File(""+ddd.getMBeanServerConnection().getAttribute(aaaa,"location"));
            }
            
            else if (ddd.getModuleType().equals(ModuleType.EAR)){
                ObjectName aaaa = new ObjectName("com.sun.appserv:type=application,name="+ddd.getModuleID()+",category=config");
                dirLocation =new java.io.File(""+ddd.getMBeanServerConnection().getAttribute(aaaa,"location"));
            } else{
                System.out.println("Still Some Work to do in ModuleRestartActikon is AS 8.1 plugin code");
            }
            
        } catch(Exception e) {
            e.printStackTrace();
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
        return dirLocation;
    }
    
    public static boolean isApp(TargetModuleID tmid) {
        ModuleType mt = ((SunTargetModuleID)tmid).getModuleType();
        return mt.equals(ModuleType.EAR);
    }
    
    public static boolean isWar(TargetModuleID tmid) {
        ModuleType mt = ((SunTargetModuleID)tmid).getModuleType();
        return mt.equals(ModuleType.WAR);
    }
    
    public static Boolean isCar(TargetModuleID tmid) {
        ModuleType mt = ((SunTargetModuleID)tmid).getModuleType();
        return Boolean.valueOf(mt.equals(ModuleType.CAR));
    }
    
    /**
     * Get the URI pointing to location of child module inside a application archive.
     * For a root module, service provider does not need to override this method.
     *
     * @param module TargetModuleID of the child module
     * @return its relative path within application archive, returns null by
     * default (for standalone module)
     */
    public static String getModuleUrl(TargetModuleID module){
        ModuleType mt = ((SunTargetModuleID)module).getModuleType();
        String suffix = ".jar";
        if (mt.equals(ModuleType.EAR)){
            suffix = ".ear";
        }
        if (mt.equals(ModuleType.WAR)){
            suffix = ".war";
        }
        if (mt.equals(ModuleType.RAR)){
            suffix = ".rar";
        }
        
        String moduleID = module.getModuleID();
        int i = moduleID.indexOf('#');
        if (i > -1) {
            moduleID = moduleID.substring(i+1);
        }
        if (moduleID.endsWith(suffix) || moduleID.endsWith(suffix.toUpperCase())) {
            return moduleID;
        }
        return moduleID + suffix;
    }
    
    
    public static String getHostPort(File domainXml, File platformDir){
        String hostPort = null;
        InputStream inFile = null;
        try {
            inFile = new BufferedInputStream(new FileInputStream(domainXml));
            Domain domain = Domain.createGraph(inFile);
            String domainSysID = domain.graphManager().getXmlDocument().getDoctype().getSystemId();
            
            // make sure the platform will support this domain..
            
            // unknown domain.xml content.. we don't support that
            if (null == domainSysID) {
                return null;
            }
            
            // the sys ID doesn't contain the content we expect... we don't support that
            int dtdsDex = domainSysID.indexOf("dtds/");                         // NOI18N
            if (-1 == dtdsDex) {
                return null;
            }
            
            File domainDtd = new File(platformDir, "lib/"+                      // NOI18N
                    domainSysID.substring(dtdsDex));
            
            // the installation doesn't have the dtd where we expect it... we don't support that
            if (!domainDtd.exists()) {
                return null;
            }
            
            Config conf = domain.getConfigs().getConfigByName("server-config"); //NOI18N
            HttpListener list = conf.getHttpService().getHttpListenerById("admin-listener"); //NOI18N
            hostPort = "localhost:" + list.getPort(); //NOI18N
        } catch (FileNotFoundException ex) {
            Logger.getLogger("org.netbeans.modules.j2ee.sun.bridge").log(Level.WARNING,"",ex); // NOI18N
        } catch (IOException ex) {
            Logger.getLogger("org.netbeans.modules.j2ee.sun.bridge").log(Level.WARNING,"",ex); // NOI18N
        } catch (RuntimeException re) {
            Logger.getLogger("org.netbeans.modules.j2ee.sun.bridge").log(Level.WARNING,"",re); // NOI18N            
        } finally {
            if (null!=inFile)
                try {
                    inFile.close();
                } catch(IOException ioe) {
                    // what about this???
                    Logger.getLogger("org.netbeans.modules.j2ee.sun.bridge").log(Level.FINE,"",ioe); // NOI18N
                }
        }
        return hostPort;
    }
    
    /* return the port number used bu the server instance (usually, it is the 8080... 
     * This is not the admin port number which is usally 4848
     **/
    public String getNonAdminPortNumber(File domainXml){
        String port = null;
        try{
            InputStream inFile = new FileInputStream(domainXml);
            Domain domain = Domain.createGraph(inFile);
            Config conf = domain.getConfigs().getConfigByName("server-config"); //NOI18N
            HttpListener list = conf.getHttpService().getHttpListenerById("http-listener-1"); //NOI18N
            port =  list.getPort(); //NOI18N
            inFile.close();
        }catch(Exception ex){
            return null;
            //Suppressing exception while trying to get admin port.
            //Null port value is handled in AddServerChoiceVisualPanel
        }
        return port;    
    }
    public     static MBeanServerConnection getJMXConnector(String host, int port, String username, String password,boolean secure) throws java.net.MalformedURLException, java.io.IOException{
        MBeanServerConnection serverConn = null;
        String mode=null;
        if (secure)
            mode="s1ashttps";
        else
            mode = "s1ashttp";
        JMXServiceURL serverUrl = new JMXServiceURL(mode, host, port); //NOI18N
        final JMXConnector connector = SunOneHttpJmxConnectorFactory.connect(serverUrl, username, password);
        serverConn = connector.getMBeanServerConnection();
        
        return serverConn;
    }
    /**
     *	This method initializes a newly DeploymentManager by creating and
     *	setting a ServerConnectionEnvironement with Deploytool's
     *	X509TrustManager.  This method will case the given DeploymentManager
     *	to a SunDeploymentManager in order to make
     *	invoke the appropriate setter for the ServerConnectionEnvironment.
     */
    public static void setServerConnectionEnvironment(DeploymentManager dm) {
	ServerConnectionEnvironment env = new ServerConnectionEnvironment();
	env.put(DefaultConfiguration.TRUST_MANAGER_PROPERTY_NAME, new X509TrustManager());
	if (dm instanceof SunDeploymentManager) {
	    ((SunDeploymentManager)dm).setServerConnectionEnvironment(env); 
	}// else {
	  //  Print.dprintStackTrace(null, new IllegalArgumentException(
//		"Unsupported DeploymentManager type: '"+
//		dm.getClass().getName()+"'."));
//	}
    }


}
