/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.bridge.apis;

import java.util.logging.Level;

import javax.swing.Action;
import org.netbeans.modules.j2ee.sun.util.ContainerChildFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.NbBundle;

/**
 *
 *
 *
 */
public class AppserverMgmtContainerNode extends AppserverMgmtNode  implements RefreshCookie {

        public static final class WaitNode extends AbstractNode {
        public WaitNode() {
            super(Children.LEAF);
            setIconBase("org/openide/src/resources/wait"); // NOI18N
            setDisplayName(NbBundle.getMessage(AppserverMgmtContainerNode.class,"WAITNODE")); //NOI18N
            setName(getClass().getName());
        }
    } // End of WaitNode class
        
    /**
     *
     */
    public AppserverMgmtContainerNode(final AppserverMgmtController controller, final String type) {
        super(controller, getChildren(controller, type), type);
    }
    /**
     *
     *
     */
    public AppserverMgmtContainerNode(final AppserverMgmtController controller, final Children children, final String nodeType) {
        super(controller, children, nodeType);

    }    
    
    /**
     * Return the actions associated with the menu drop down seen when
     * a user right-clicks on an Applications node in the plugin.
     *
     * @param boolean true/false
     * @return An array of Action objects.
     */
    public Action[] getActions(boolean flag) {
        return new SystemAction[] {
            SystemAction.get(RefreshAction.class)
        };
    }

    /**
     *
     */
    static Children getChildren(final AppserverMgmtController controller,  final String type){
        return new ContainerChildren(controller, type);
    }

    
    /**
     *
     *
     */
    public void refresh(){
        setChildren(new ContainerChildren(getAppserverMgmtController(), getNodeType()));
        ContainerChildren ch = (ContainerChildren)getChildren();
        ch.updateKeys();
    }

    
    /**
     *
     *
     */
    public static class ContainerChildren extends Children.Keys {
        String type;
        ContainerChildFactory cfactory;
        public ContainerChildren(AppserverMgmtController controller, String type) {
            if(controller == null) {
                getLogger().log(Level.FINE, "Controller for child factory " +
                    "is null");
                getLogger().log(Level.FINE, "Type: " + type);
            }
            this.type = type;
            this.cfactory = new ContainerChildFactory(controller);
        }
        protected void addNotify() {
            
            Node n[]= new Node[1];
            n[0]=new WaitNode();
            setKeys(n);
            RequestProcessor.getDefault().post(new Runnable() {
                public void run() {
                    try {
                        setKeys(cfactory.getChildrenObject(type));
                    } catch (RuntimeException e) {
                        getLogger().log(Level.FINE, e.getMessage(), e);
                    }
                }
            });
            
        }
        protected void removeNotify() {
            setKeys(java.util.Collections.EMPTY_SET);
        }
        public void updateKeys() {
            refresh();
        }
        protected org.openide.nodes.Node[] createNodes(Object obj) {
            try {
                return new Node[] { (Node)obj };
            } catch(RuntimeException rex) {
                getLogger().log(Level.FINE, rex.getMessage(), rex);
                return new Node[] {};
            } catch(Exception e) {
                getLogger().log(Level.FINE, e.getMessage(), e);
                return new Node[] {};
            }
        }
    }
}
