/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.bridge.apis;

import java.util.logging.Logger;
import java.util.logging.Level;


import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;

/**
 * The parent class for all appserver plugin management nodes. All nodes for
 * the NetBeans runtime tab J2EE plugin must extend this class for effectively
 * communicating via AMX API.
 */
public abstract class AppserverMgmtNode extends AbstractNode {
    
    private String nodeType;
    private AppserverMgmtController appsrvrMgmtController;
    private static Logger logger;
    
    static {
        logger = Logger.getLogger("org.netbeans.modules.j2ee.sun");
    }
    
    
    /**
     *
     */
    public AppserverMgmtNode(final Children children, final String nodeType) {
        super(children);
        setNodeProperties(nodeType);
        // getAppserverMgmtController();
    }
    
    /**
     *
     *
     */
    public AppserverMgmtNode(final AppserverMgmtController controller,
            final Children children, final String nodeType) {
        super(children);
        setNodeProperties(nodeType);
        appsrvrMgmtController = controller;
    }
    
    
    /**
     *
     *
     */
    // Shouldn't this be put into the lookup?
    public AppserverMgmtController getAppserverMgmtController() {
        try {
            if(appsrvrMgmtController == null) {
                getLogger().log(Level.FINE, "AppserverMgmtController is " +
                        "null for [" + getNodeType() + "]");
            }
        } catch(Exception e) {
            getLogger().log(Level.FINE, e.getMessage(), e);
        }
        return appsrvrMgmtController;
    }
    
    /* reset the controller from the Deployment manager
     * used when the username of the password known for the connexion is changed 
     * via the IDE for example
     **/
    public void setAppserverMgmtController(AppserverMgmtController controller) {
        appsrvrMgmtController = controller;
    }    
    /**
     *
     *
     */
    public String getNodeType(){
        return nodeType;
    }
    
    
    /**
     *
     */
    private void setNodeProperties(final String nodeType) {
        this.nodeType = nodeType;
        setDisplayName(getNodeDisplayName());
        setIconBaseWithExtension(getNodeIconPath());
        setShortDescription(getNodeShortDescription());
    }
    
    /**
     *
     */
    protected String getNodeDisplayName() {
        String s=nodeType;
        try{
            s=NbBundle.getMessage(AppserverMgmtNode.class, nodeType);
        } catch (Exception e){
            return s;
        }
        return s;
        
    }
    
    /**
     *
     */
    protected String getNodeIconPath() {
        String   s="org/netbeans/modules/j2ee/sun/ide/resources/ServerInstanceIcon.png";
        try{
             s= NbBundle.getMessage(AppserverMgmtNode.class, nodeType + "_ICON");
        } catch (Exception e){
            return s;
            
        }
        return s;
    }
    
    /**
     *
     */
    protected String getNodeShortDescription() {
        String   s="missing _SHORT_DESC for " + nodeType;
        try{
             s= NbBundle.getMessage(AppserverMgmtNode.class, nodeType + "_SHORT_DESC");
        } catch (Exception e){
            
        }
        return s; 
    }
    
    
    /**
     * Returns the logger for all nodes.
     *
     * @returns The java.util.logging.Logger impl. for this node.
     */
    protected final static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("org.netbeans.modules.j2ee.sun");
        }
        return logger;
    }
    
    public boolean isServerLocal(){
        return appsrvrMgmtController.isDeployMgrLocal();
    }
}
