/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.bridge.apis;

import java.util.List;


/**
 * A controller is responsible for acting as the bridge between Netbeans 
 * apis and the Sun Java Application Server AMX api for managment and monitoring.
 * This allows for the decoupling of the data model (AMX) from the Netbeans
 * node view.
 */
public interface Controller {
    
    
    /**
     * Returns the properties of this controller in a java.util.Map.
     * 
     * @propsToIgnore The String properties to ignore.
     * @return All the properties for this controller.
     */
    public java.util.Map getProperties(List propsToIgnore);
    
    /**
     * Sets a property given a name/value pair.
     *
     * @param attrName The name of the attribute to set.
     * @param value The value of the attribute to set.
     *
     * @return the updated Attribute.
     */
    public javax.management.Attribute setProperty(final String attrName, final Object value);
    
    /**
     * Returns the name of the component which this controller manages.
     *
     * @return The name of the component. 
     */
    public String getName();
    
}
