/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.ide.controllers;

import java.util.List;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.config.AppClientModuleConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.j2ee.AppClientModule;

import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtControllerBase;

import org.netbeans.modules.j2ee.sun.util.NodeTypes;


/**
 * Used as a conduit between the Netbeans API's and the AMX MBean API
 * data model. This API contains convenient methods for retrieving
 * components allowing the netbeans module heirarchy remain agnostic to the
 * underlying data model. 
 * 
 * This controller is used to navigate through deployed app client modules.
 */
public class AppClientModuleController extends AppserverMgmtControllerBase 
        implements DeployedItemsController, EnablerController {
    
    private AppClientModule appClientModule;
    private AppClientModuleConfig appClientModuleConfig;
    
    
    /**
     * Create an instance of J2EEServerMgmtController used in the interaction
     * with AMX API for Sun Java System Application Server. 
     * 
     * @param server The AMX J2EEServer object representing a particular server.
     */
    public AppClientModuleController(AppClientModule appClientModule, 
            AppserverConnectionSource connection) {
        super(appClientModule, connection);
        this.appClientModule = appClientModule;
    }

    
    /**
     * Create an instance of J2EEServerMgmtController used in the interaction
     * with AMX API for Sun Java System Application Server. 
     * 
     * @param server The AMX J2EEServer object representing a particular server.
     */
    public AppClientModuleController(final AppClientModule appClientModule, 
            final DeploymentManager dplmtMgr,
            final AppserverConnectionSource connection) {
        super(appClientModule, dplmtMgr, connection);
        this.appClientModule = appClientModule;
    }
    
    public AppClientModuleController(final AppClientModule appClientModule, 
            final AppClientModuleConfig appClientModuleConfig,
            final DeploymentManager dplmtMgr,
            final AppserverConnectionSource connection) {
        super(appClientModuleConfig, dplmtMgr, connection);
        this.appClientModule = appClientModule;
        this.appClientModuleConfig = appClientModuleConfig;
    }
    
    /**
     * Returns the properties of the application given the name.
     * 
     * @param propsToIgnore String Properties to ignore
     * @return All the application properties.
     */
    public java.util.Map getProperties(List propsToIgnore) {
        return getJ2EEAndConfigProperties(NodeTypes.APP_CLIENT_MODULE, 
            this.appClientModule, this.appClientModuleConfig, propsToIgnore);
    }
    
    /**
     * Sets the properties.
     *
     * @param attrname The name of the attribute.
     * @param value The value of the attribute to set.
     *
     * @return updated Attribute 
     */
    public javax.management.Attribute setProperty(final String attrName, final Object value) { 
        
        testIfServerInDebug();
        
        return ControllerUtil.setAttributeValue(appClientModule, appClientModuleConfig, attrName, value, 
            getMBeanServerConnection());
    }
    
    
    /**
     *
     *
     *
     */
    public boolean isEnabled() {
        testIfServerInDebug();
        boolean configEnabled = ((Enabled)appClientModuleConfig).getEnabled();
        return ControllerUtil.calculateIsEnabled(appClientModuleConfig, configEnabled);
    }
    
    
    /**
     *
     *
     *
     */
    public void setEnabled(boolean enabled) {
        testIfServerInDebug();
        DeployedItemRefConfig config = ControllerUtil.getDeployedItemRefConfig(appClientModuleConfig);
        if(config != null)
            config.setEnabled(enabled);
    }

}
