/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.ide.controllers;

import java.util.HashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.logging.Level;
import java.io.IOException;
import java.lang.reflect.Method;

import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.enterprise.deploy.spi.DeploymentManager;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.j2ee.J2EEManagedObject;
import com.sun.appserv.management.j2ee.J2EETypes;
import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.ModuleConfig;
import com.sun.appserv.management.config.ResourceConfig;
import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.config.ServerConfig;
import java.io.File;

import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtController;
import org.netbeans.modules.j2ee.sun.util.AppserverConnectionFactory;
import org.netbeans.modules.j2ee.sun.util.GUIUtils;
import org.netbeans.modules.j2ee.sun.util.NodeTypes;
import org.netbeans.modules.j2ee.sun.util.PluginRequestInterceptor;
import org.openide.util.NbBundle;

/**
 *
 */
public class ControllerUtil {
    
    private static final String DELIMINATOR = " ";
    private static String PROPERTIES_INTERFACE = "PropertiesAccess";
    private static String DESCRIPTION_INTERFACE = "Description";
    private static String ENABLED_INTERFACE = "Enabled";
    private static String RESOURCE_CONFIG_INTERFACE = "ResourceConfig";
    private static String MODULE_CONFIG_INTERFACE = "ModuleConfig";
    private static String J2EE_DEPLOYED_OBJ_INTERFACE = "J2EEDeployedObject"; 
    private static String OBJECT_TYPE_INTERFACE = "ObjectType";
    private static String NAME_ATTRIBUTE = "Name";
    private static String JNDI_NAME_ATTRIBUTE = "JNDIName";    
    
    private static final String ASADMIN_KEY = "asadmin";
    private static final String ADMIN_GUI_KEY = "admingui";
    private static final String ADMIN_APP_KEY = "adminapp";
    private static final String WEB_UI_KEY = "com_sun_web_ui";
    private static final String MEJB_SYS_APP = "MEjbApp";
    private static final String EJB_TIMER_SYS_APP = "__ejb_container_timer_app";
    private static final String JWS_APPCLIENTS_KEY = "__JWSappclients";
    private static final String SERVER_KEY = "//server/";
    
    public static final String[] RES_ADAPTOR_KEYS = {"__xa", "jmsra", "__ds"};
    
    private static final String CONFIG_OBJ_NAME = "com.sun.appserv:type=applications,category=config";
    private static Logger logger;
    private static Map j2eeTypeToConfigMap;
    
    private static final String DAS_SERVER_NAME = "server";
    
    static {
        logger = Logger.getLogger("org.netbeans.modules.j2ee.sun");
    }
    
    static {
        j2eeTypeToConfigMap = new HashMap();
        j2eeTypeToConfigMap.put(J2EETypes.J2EE_DOMAIN, XTypes.DOMAIN_CONFIG);
        j2eeTypeToConfigMap.put(J2EETypes.J2EE_CLUSTER, XTypes.CLUSTER_CONFIG);
        j2eeTypeToConfigMap.put(J2EETypes.J2EE_SERVER, 
                XTypes.STANDALONE_SERVER_CONFIG);
        j2eeTypeToConfigMap.put(J2EETypes.JVM, XTypes.JAVA_CONFIG);
        j2eeTypeToConfigMap.put(J2EETypes.J2EE_APPLICATION, 
                XTypes.J2EE_APPLICATION_CONFIG);
        j2eeTypeToConfigMap.put(J2EETypes.EJB_MODULE, XTypes.EJB_MODULE_CONFIG);
        j2eeTypeToConfigMap.put(J2EETypes.WEB_MODULE, XTypes.WEB_MODULE_CONFIG);
        j2eeTypeToConfigMap.put(J2EETypes.APP_CLIENT_MODULE, 
                XTypes.APP_CLIENT_MODULE_CONFIG);
        j2eeTypeToConfigMap.put(J2EETypes.RESOURCE_ADAPTER_MODULE, 
                XTypes.RAR_MODULE_CONFIG);
        j2eeTypeToConfigMap.put(J2EETypes.RESOURCE_ADAPTER, 
                XTypes.RESOURCE_ADAPTER_CONFIG);
     }

    
    /**
     * Private constructor to avoid instantiation.
     */
    private ControllerUtil() {
    }
    
    
    /**
     *
     *
     */
    public static AppserverMgmtController  getAppserverMgmtControllerFromDeployMgr(final DeploymentManager deployMgr) {
        AppserverConnectionSource con = createAppserverConnFromDeploymentMgr(deployMgr);
        if (con==null){
            return null; //no way to get a valid controller sinc the connection is bad: no password, or bad one
        }
        else {
            return new AppserverMgmtController(deployMgr, con);
        }
    }
    
    
    /**
     *
     *
     */
    public static AppserverConnectionSource  createAppserverConnFromDeploymentMgr(final DeploymentManager deployMgr) {
        AppserverConnectionSource connection = null;
        SunDeploymentManagerInterface sunDpmtMgr = 
                (SunDeploymentManagerInterface) deployMgr;

        try {    
           // connection = AppserverConnectionFactory.getAppserverConnection(
            connection = AppserverConnectionFactory.getHTTPAppserverConnection(
                sunDpmtMgr.getHost(), sunDpmtMgr.getPort(), 
                sunDpmtMgr.getUserName(), sunDpmtMgr.getPassword(), 
                sunDpmtMgr.isSecure());
            
            //next line is important to test if the connection is correct. If it is not, the expcetion is raised
            //so that we can return a null one.
           connection.getDomainRoot();

        } catch (Exception ioex) {
            connection=null;
            //GUIUtils.showError("Bad AppserverConnection:     "+ioex.getMessage());


        
        }
        return connection;
    }
    
    
    /**
     *
     *
     */
    public static MBeanServerConnection getMBeanServerConnWithInterceptor(
            final SunDeploymentManagerInterface sunDplymtIntrface,
            final AppserverConnectionSource connSource) {
        MBeanServerConnection conn = null;
        try {
            conn = connSource.getMBeanServerConnection(false);
        } catch (IOException io) {
            logger.log(Level.FINE, io.getMessage(), io);
        }
        MBeanServerConnection connWithInterceptor =
            new PluginRequestInterceptor(sunDplymtIntrface, conn);
        return connWithInterceptor;
    }
    
    
    /**
     *
     *
     */
    static public AMX getAMXComponentFromMap(Map map, String keyName) {
        for(Iterator itr = map.values().iterator(); itr.hasNext(); ) {            
            AMX component = (AMX)itr.next();
            if(component.getName().equals(keyName)) {
                return component;
            }
        }
        return null;
    }
    
    
    /**
     *
     */
    static public String[] getComponentNamesFromMap(Map map) {
       String [] names = new String[map.size()];
       int pos = 0;
       for(Iterator itr = map.values().iterator(); itr.hasNext(); ) {
           AMX component = (AMX)itr.next();
           names[pos] = component.getName();
           pos++;
       }
       return names;
    }
    
    /**
     * Return a string representation of an array.
     */
    static public String arrayToString(Object [] array) {
        StringBuffer buffer = new StringBuffer();
        for(int i = 0; i < array.length; i++) {
            buffer.append(array[i]);
            buffer.append(DELIMINATOR);
        }
        return buffer.toString();
    }
    
    
    /**
     *
     *
     */
    public static Map getAllAttributes(final Class clazz, 
            final AMX amx, final List propsToIgnore, 
            final MBeanServerConnection conn, final String nodeType) {
        Map attrs = null;
        Set declaredAttrs =  
            extractAttributeNamesFromMethods(
                getGetterMethods(clazz.getDeclaredMethods()));
        Set inheritedAttrs = getExtraAttributes(clazz);
        declaredAttrs.addAll(inheritedAttrs);
        if(isJNDINameAbsent(declaredAttrs)) {
            declaredAttrs.add(NAME_ATTRIBUTE);
        }
        if(nodeType.equals(NodeTypes.WEB_MODULE)){
            //In this filter, the props in the list are displayed and the rest ignored.    
            attrs = getAttributeProperties(
                applyFilterToAttributeNamesForWeb(propsToIgnore,declaredAttrs), amx, conn);
        }else{
            attrs =  getAttributeProperties(
                applyFilterToAttributeNames(propsToIgnore,declaredAttrs), amx, conn);
        }    
        attrs = modifyEnabledProperty(attrs, amx);
        return attrs;
    }
    
    /**
     *
     *
     */
    private static Set getExtraAttributes(Class clazz) {
        Set attrSet = new HashSet();
        Class [] classes = clazz.getInterfaces();
        for(int i = 0; i < classes.length; i++) {
            if(isExtraInterface(getSimpleClassName(classes[i]))) {
                attrSet.addAll(extractAttributeNamesFromMethods(
                        getGetterMethods(classes[i].getDeclaredMethods())));
                
            }
            attrSet.addAll(getExtraAttributes(classes[i]));
        }
        return attrSet;
    }
    
    /**
     *
     */
    private static String getSimpleClassName(Class clazz) {
        String fullClassName = clazz.getName();
        int lastIndex = fullClassName.lastIndexOf(".");
        return fullClassName.substring(lastIndex + 1, 
            fullClassName.length()).trim();
    }
    
    /**
     *
     *
     */
    private static boolean isExtraInterface(String intrfaceName) {
        return (DESCRIPTION_INTERFACE.equals(intrfaceName) 
                || ENABLED_INTERFACE.equals(intrfaceName) 
                || PROPERTIES_INTERFACE.equals(intrfaceName) 
                || RESOURCE_CONFIG_INTERFACE.equals(intrfaceName)
                || J2EE_DEPLOYED_OBJ_INTERFACE.equals(intrfaceName)
                || MODULE_CONFIG_INTERFACE.equals(intrfaceName)
                || OBJECT_TYPE_INTERFACE.equals(intrfaceName)); 
    }
    
    
    /**
     *
     */
    private static boolean isJNDINameAbsent(Set attrs) {
        for(Iterator itr = attrs.iterator(); itr.hasNext(); ) {
            if(JNDI_NAME_ATTRIBUTE.equals(itr.next())) {
                return false;
            }
        }
        return true;
    }
    
    
    /**
     *
     */
    private static Set applyFilterToAttributeNames(
            final List propsToIgnore, final Set names) {
       if(propsToIgnore != null && propsInListAreStrings(propsToIgnore)) {
           for(Iterator itr = propsToIgnore.iterator(); itr.hasNext(); ) {
               String name = (String) itr.next();
               if(names.contains(name)) {
                   names.remove(name);
               }
           }
       }
       return names;
    }
    
    private static Set applyFilterToAttributeNamesForWeb(
    final List propsToAdd, final Set names) {
        Set attrNames = new HashSet();
        if(propsToAdd == null){
            return names;
        }
        if(propsToAdd != null && propsInListAreStrings(propsToAdd)) {
            for(Iterator itr = propsToAdd.iterator(); itr.hasNext(); ) {
                String name = (String) itr.next();
                if(names.contains(name)) {
                    attrNames.add(name);
                }
            }
        }
        return attrNames;
    }
    
    
    /**
     *
     */
    public static boolean propsInListAreStrings(List propsToIgnore) {
       for(Iterator itr = propsToIgnore.iterator(); itr.hasNext(); )  {
           if(!(itr.next() instanceof String)) {
                   return false;
           }
       }
       return true;
    }
    
    
    /**
     *
     *
     */
    private static Map getAttributeProperties(Set names, AMX amx, 
            MBeanServerConnection conn) {
        //get attribute info
        Map returnMap = new HashMap();
        final ObjectName on = Util.getObjectName(amx);
        //get the attribute info
        try {
            final MBeanInfo mi = conn.getMBeanInfo(on);
            final MBeanAttributeInfo[] mai = mi.getAttributes();
            for (int i = 0 ; i < mai.length ; i++) {
                if (mai[i] != null && names.contains(mai[i].getName())) {
                    //get the attribute from the mbean
                    try {
                        Object attrValue = conn.getAttribute(on, mai[i].getName());
                        //put it in the return map indexed by attribute
                        returnMap.put(new Attribute(mai[i].getName(), 
                                attrValue), mai[i]);
                    } catch(javax.management.AttributeNotFoundException ex) {
                        continue;
                    }
                }
            }
        } catch(Exception e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        if(returnMap.size() == 0 || returnMap == null) {
            logger.log(Level.FINE, "The return Map in getAttrProperties is " +
                    "size 0!");
        }
        return returnMap;
    }
    

    /**
     * 
     *
     */
    public static Set extractAttributeNamesFromMethods(final Method[] method) {
        final Set attrNames = new HashSet();
        for (int i = 0 ; i < method.length ; i++) {
            final String methodName = method[i].getName();
            final String name = 
                methodName.substring(methodName.indexOf("get")+3);
            attrNames.add(name);
        }
        return attrNames;
    }
    
    
    /**
     *
     *
     */
    public static Method[] getGetterMethods(Method[] methods) {
        final Vector v = new Vector();
        for (int i = 0 ; i < methods.length ; i++) {
            if (methods[i].getName().startsWith("get")
                    && !methods[i].getName().endsWith("Stats")) {
                v.add(methods[i]);
            }
        }
        final Method[] mm = new Method[v.size()];
        return (Method[]) v.toArray(mm);
    }
    
    
    /**
     *
     *
     */
    public static AMX getConfigPeer(final AMX amx) {
        J2EEManagedObject managedObj = (J2EEManagedObject) amx;
        AMX configPeer = managedObj.getConfigPeer();
        if(configPeer != null) {
            return configPeer;
        } else {
            String configXType = getConfigPeerAMXType(amx.getJ2EEType());
            QueryMgr queryMgr = amx.getDomainRoot().getQueryMgr();
            java.util.Set set = queryMgr.queryJ2EETypeSet(configXType);
            for(Iterator itr = set.iterator(); itr.hasNext(); ) {
                AMX config = (AMX) itr.next();
                if(config.getName().equals(amx.getName())) {
                    return config;
                }
            }
        }
       return null;
    }
    
    
    /**
     *
     *
     */
    public static Attribute setAttributeValue(AMX j2eeMod, AMX configPeer, String attrName, Object value,
            MBeanServerConnection conn) {
        Attribute modAttr = new Attribute(attrName, value);
        try {
            if(attrName.equals(NodeTypes.ENABLED) && (configPeer != null)){
                updateEnabled(configPeer, value);
            }else{
                ObjectName configOn = Util.getObjectName(configPeer);
                conn.setAttribute(configOn, modAttr);
            }
        } catch (RuntimeMBeanException e) {
            if(j2eeMod != null){
                ObjectName j2eeOn = Util.getObjectName(j2eeMod);
                modAttr = setAttrValue(j2eeOn, attrName, modAttr, conn);
            }else
                modAttr = null;
        } catch (Exception ex) {
            Object [] params = new Object[] {attrName, ex.getMessage()};
            GUIUtils.showError(
                getLocalizedString("unexpected_setAttr_except", params));
            modAttr = null;
        }
        return modAttr;
    }
    
    public static Attribute setAttributeValue(AMX amx, String attrName, Object value,
            MBeanServerConnection conn) {
        final ObjectName on = Util.getObjectName(amx);
        Attribute modAttr = new Attribute(attrName, value);
        try {
            if(attrName.equals(NodeTypes.ENABLED) && (amx != null))
                updateEnabled(amx, value);
            else
                conn.setAttribute(on, modAttr);
        } catch (RuntimeMBeanException e) {
            modAttr = setAttributeOnConfigPeer(amx, attrName, value, conn);
        } catch (Exception ex) {
            Object [] params = new Object[] {attrName, ex.getMessage()};
            GUIUtils.showError(
                getLocalizedString("unexpected_setAttr_except", params));
            modAttr = null;
        }
        return modAttr;
    }
    
    private static void updateEnabled(AMX amx, Object value){
        if(amx instanceof ResourceConfig){
            setResourceEnabled((ResourceConfig)amx, value);
        } else {
            if(amx instanceof ModuleConfig)
                setModuleEnabled((ModuleConfig)amx, value);
        }
    }
    
    private static Attribute setAttrValue(ObjectName on, String attrName, Attribute modAttr,
            MBeanServerConnection conn) {
        try {
            conn.setAttribute(on, modAttr);
        } catch (Exception ex) {
            Object [] params = new Object[] {attrName, ex.getMessage()};
            GUIUtils.showError(
                getLocalizedString("unexpected_setAttr_except", params));
            modAttr = null;
        }
        return modAttr;
    }
    
    /**
     *
     *
     */
     public static void setPropertyValue(com.sun.appserv.management.config.ResourceConfig resConfig, Object[] props) {
        try {
            for(int i=0; i<props.length; i++){
                Attribute attr = (Attribute)props[i];
                String propValue = null;
                if(attr.getValue() != null){
                    propValue = attr.getValue().toString();
                }
                resConfig.setPropertyValue(attr.getName(), propValue);
            }
        } catch (RuntimeMBeanException e) {
            Object [] params = new Object[] {resConfig.getJNDIName(), e.getMessage()};
            GUIUtils.showError(
                getLocalizedString("unexpected_setProp_except", params));
        } catch (Exception ex) {
            Object [] params = new Object[] {resConfig.getJNDIName(), ex.getMessage()};
            GUIUtils.showError(
                getLocalizedString("unexpected_setProp_except", params));
        }
    }
    
     /**
      *
      *
      */
     public static void setPropertyValue(com.sun.appserv.management.config.JDBCConnectionPoolConfig resConfig, Object[] props) {
         try {
             for(int i=0; i<props.length; i++){
                 Attribute attr = (Attribute)props[i];
                 String propValue = null;
                 if(attr.getValue() != null){
                     propValue = attr.getValue().toString();
                 }
                 resConfig.setPropertyValue(attr.getName(), propValue);
             }
         } catch (RuntimeMBeanException e) {
             Object [] params = new Object[] {resConfig.getName(), e.getMessage()};
             GUIUtils.showError(
                     getLocalizedString("unexpected_setProp_except", params));
         } catch (Exception ex) {
             Object [] params = new Object[] {resConfig.getName(), ex.getMessage()};
             GUIUtils.showError(
                     getLocalizedString("unexpected_setProp_except", params));
         }
     }
     
     /**
      *
      *
      */
     public static void setPropertyValue(com.sun.appserv.management.config.ConnectorConnectionPoolConfig resConfig, Object[] props) {
         try {
             for(int i=0; i<props.length; i++){
                 Attribute attr = (Attribute)props[i];
                 String propValue = null;
                 if(attr.getValue() != null){
                     propValue = attr.getValue().toString();
                 }
                 resConfig.setPropertyValue(attr.getName(), propValue);
             }
         } catch (RuntimeMBeanException e) {
             Object [] params = new Object[] {resConfig.getName(), e.getMessage()};
             GUIUtils.showError(
                     getLocalizedString("unexpected_setProp_except", params));
         } catch (Exception ex) {
             Object [] params = new Object[] {resConfig.getName(), ex.getMessage()};
             GUIUtils.showError(
                     getLocalizedString("unexpected_setProp_except", params));
         }
     }
     
    /**
     *
     *
     */
    private static Attribute setAttributeOnConfigPeer(final AMX amx, 
            final String attrName, final Object value, 
            final MBeanServerConnection conn) {
        AMX configPeer = getConfigPeer(amx);
        Attribute modAttr = new Attribute(attrName, value);
        try {
            final ObjectName on = Util.getObjectName(configPeer);
            conn.setAttribute(on, modAttr);
        } catch (RuntimeMBeanException e) {
            Object [] params = new Object[] {attrName, e.getMessage()};
            GUIUtils.showError(
                getLocalizedString("unexpected_setAttrConfigPeer_except", params));
            modAttr = null;
        } catch (Exception ex) {
            Object [] params = new Object[] {attrName, ex.getMessage()};
            GUIUtils.showError(
                getLocalizedString("unexpected_setAttrConfigPeer_except", params));
            modAttr = null;
        }
        return modAttr;
    }
    
    
    /**
     * Removes all system level modules on the Sun Java System 
     * Application Server. 
     *
     * @param allModuleNames All the names of the app and/or web modules.
     * @return All the non-system related modules.
     */
    protected static String[] stripOutSystemApps(String [] allModuleNames) {
        final java.util.Vector nonSystemApps = new java.util.Vector();
        for(int i = 0; i < allModuleNames.length; i++) {
            if(allModuleNames[i].indexOf(ASADMIN_KEY) == -1
                    && allModuleNames[i].indexOf(MEJB_SYS_APP) == -1
                    && allModuleNames[i].indexOf(EJB_TIMER_SYS_APP) == -1
                    && allModuleNames[i].indexOf(JWS_APPCLIENTS_KEY) == -1 
                    && ! allModuleNames[i].matches(SERVER_KEY) ) {
                nonSystemApps.add(allModuleNames[i]);
            }
        }
        final String[] str = new String[nonSystemApps.size()];
        return (String[]) nonSystemApps.toArray(str);
    }
    
    
    /**
     * Removes all system level modules on the Sun Java System 
     * Application Server. 
     *
     * @param allModules All the app and/or web modules.
     * @return All the non-system related modules.
     */
    protected static Map stripOutSystemApps(final Map allModules) {
        Map nonSystemApps = new HashMap();
        for(Iterator itr = allModules.keySet().iterator(); itr.hasNext();) {
            String moduleName = (String) itr.next();
            if(moduleName.indexOf(ASADMIN_KEY) == -1
                    && moduleName.indexOf(ADMIN_GUI_KEY) == -1
                    && moduleName.indexOf(ADMIN_APP_KEY) == -1
                    && moduleName.indexOf(WEB_UI_KEY) == -1
                    && moduleName.indexOf(MEJB_SYS_APP) == -1
                    && moduleName.indexOf(EJB_TIMER_SYS_APP) == -1
                    && moduleName.indexOf(JWS_APPCLIENTS_KEY) == -1
                    && ! moduleName.matches(SERVER_KEY)) {
                nonSystemApps.put(moduleName, allModules.get(moduleName));
            }
        }
        return nonSystemApps;
    }
    
    
    /**
     *
     */
    public static String getConfigPeerAMXType(final String j2eeType) {
        return (String) j2eeTypeToConfigMap.get(j2eeType);
    }
    
    
    
    /**
      * Checks to see if the appserver is suspended in debug mode. If the 
      * server is suspended, then a popup error window is displayed and a 
      * java.lang.RuntimeException is thrown to avoid IDE hanging.
      *
      * @param dplymtMgr The DeploymentManager used to determining the status
      *        of the appserver.
      */
     public static void checkIfServerInDebugMode(final DeploymentManager dplymtMgr) {
        SunDeploymentManagerInterface sunDpmtMgr =
                (SunDeploymentManagerInterface) dplymtMgr;
        if(sunDpmtMgr != null) {
            if(sunDpmtMgr.isSuspended()) {
                GUIUtils.showInformation(
                    getLocalizedString("server_dbg_mode_notify"));
                throw new RuntimeException(
                    getLocalizedString("server_dbg_mode_notify"));
            } 
        }
    }

     
    /**
     *
     *
     */
     public static Map getLogAttributes(final AMX config, final Map propNames, final MBeanServerConnection conn){
            Map returnMap = new HashMap();
            final ObjectName on = Util.getObjectName(config);
            //get the attribute info
            try {
                final MBeanInfo mi = conn.getMBeanInfo(on);
                final MBeanAttributeInfo[] mai = mi.getAttributes();
                for (int i = 0 ; i < mai.length ; i++) {
                    if (mai[i] != null && propNames.containsKey(mai[i].getName())) {
                        //get the attribute from the mbean
                        try {
                            Object attrValue = conn.getAttribute(on, mai[i].getName());
                            //put it in the return map indexed by attribute
                            returnMap.put(new Attribute(mai[i].getName(),
                                    attrValue), mai[i]);
                        } catch(javax.management.AttributeNotFoundException ex) {
                            continue;
                        }
                    }
                }
            } catch(Exception e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            if(returnMap.size() == 0 || returnMap == null) {
                logger.log(Level.FINE, "The return Map in getAttrProperties is " +
                        "size 0!");
            }
            return returnMap;
     }
     
    /**
     *
     *
     */
    private static String getLocalizedString(final String bundleStrProp) {
        return NbBundle.getMessage(ControllerUtil.class, 
                bundleStrProp);
    }
    
    
    /**
     *
     *
     */
    private static String getLocalizedString(final String bundleStrProp,
            final Object[] params) {
        return NbBundle.getMessage(ControllerUtil.class, 
                bundleStrProp, params);
    }
    
    public static boolean isGlassFish(DeploymentManager dm){
	//now test for AS 9 (J2EE 5.0) which should work for this plugin
        File candidate = ((SunDeploymentManagerInterface)dm).getPlatformRoot();
        File as9 = new File(candidate.getAbsolutePath()+
                "/lib/dtds/sun-web-app_2_5-0.dtd");                             //NOI18N
        return as9.exists();
    }
    
    public static ObjectName[] getSubComponentsFromConfig(String modName, MBeanServerConnection conn){
        String[] subComponents = new String[] {};
        try{
            ObjectName oName = new ObjectName(CONFIG_OBJ_NAME);
            Object[] params = {modName};
            String[] signature = {"java.lang.String"};
            subComponents = (String[])conn.invoke(oName, "getModuleComponents", params, signature);
        }catch(Exception ex){}           
        return convertToObjNames(subComponents);
    }
    
    private static ObjectName[] convertToObjNames(String[] objNames){
        try{
            ObjectName[] compNames = new ObjectName[objNames.length];
            for(int i=0; i<objNames.length; i++){
                ObjectName name = new ObjectName(objNames[i]);
                compNames[i] = name;
            }
            return compNames;
        }catch(Exception ex){
            return new ObjectName[0];
        }            
    }
        
    private static void setResourceEnabled(ResourceConfig resConfig, Object value){
        boolean val = Boolean.valueOf(value.toString()).booleanValue();
        ResourceRefConfig config = getResourceRefConfig(resConfig);
        if(config != null)
            config.setEnabled(val);
    }
    
    private static void setModuleEnabled(ModuleConfig modConfig, Object value){
        boolean val = Boolean.valueOf(value.toString()).booleanValue();
        DeployedItemRefConfig config = getDeployedItemRefConfig(modConfig);
        if(config != null)
            config.setEnabled(val);
    }
    
    private static ResourceRefConfig getResourceRefConfig(AMX appConfig){
        String appName = appConfig.getName();
        ResourceRefConfig itemName = (ResourceRefConfig)getDASConfig(appConfig).getResourceRefConfigMap().get(appName);
        return itemName;
    }
    
    private static ServerConfig getDASConfig(AMX appConfig){
        Map serverConfigs = getServerInstancesMap(appConfig);
        ServerConfig serverConfig = (ServerConfig)serverConfigs.get(DAS_SERVER_NAME);
        return serverConfig;
    }
    
    public static Map modifyEnabledProperty(Map j2eeProps, AMX configPeer){
        Map modProps = j2eeProps;
        for(Iterator itr = j2eeProps.keySet().iterator(); itr.hasNext(); ) {
            Attribute attr = (Attribute) itr.next();
            if(attr.getName().equals(NodeTypes.ENABLED)){
                MBeanAttributeInfo info = (MBeanAttributeInfo) j2eeProps.get(attr);
                Boolean value = (Boolean)attr.getValue();
                boolean attrVal = calculateIsEnabled(configPeer, value.booleanValue());
                Attribute enabled = new Attribute(NodeTypes.ENABLED, Boolean.valueOf(attrVal));
                modProps.remove(attr);
                modProps.put(enabled, info);
                break;
            }
        }
        return modProps;
    }
    
    protected static boolean calculateIsEnabled(AMX appConfig, boolean configEnabled){
        boolean isEnabled = configEnabled;
        boolean refEnabled = configEnabled;
        if(appConfig instanceof ResourceConfig) {
            ResourceRefConfig itemName = getResourceRefConfig(appConfig);
            if(itemName != null)
                refEnabled = itemName.getEnabled();
        } else {
            DeployedItemRefConfig itemName = getDeployedItemRefConfig(appConfig);
            if(itemName != null)
                refEnabled = itemName.getEnabled();
        }
        if(!configEnabled || !refEnabled)
            isEnabled = false;
        
        return isEnabled;
    }
    
    protected static DeployedItemRefConfig getDeployedItemRefConfig(AMX appConfig){
        String appName = appConfig.getName();
        DeployedItemRefConfig itemName = (DeployedItemRefConfig)getDASConfig(appConfig).getDeployedItemRefConfigMap().get(appName);
        return itemName;
    }
  
    public static String[] getServerTargets(AMX amx){
        return getComponentNamesFromMap(getServerInstancesMap(amx));
    }
    
    public static Map getServerInstancesMap(AMX amx) {
       Map serverConfigs = amx.getDomainRoot().getDomainConfig().getServerConfigMap();
       return serverConfigs;
    } 
    
    public static Map getStandaloneServerInstancesMap(AMX amx) {
       Map serverConfigs = amx.getDomainRoot().getDomainConfig().getStandaloneServerConfigMap();
       return serverConfigs;
    }
}
