/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.ide.runtime.actions;

import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;
import org.openide.util.NbBundle;
import org.openide.util.HelpCtx;

import org.netbeans.modules.j2ee.sun.bridge.apis.Enableable;

import org.netbeans.modules.j2ee.sun.bridge.apis.RefreshCookie;

/**
 *
 *
 */
public class EnableDisableAction extends NodeAction {
    
    private boolean enabled;
    
    
    /**
     *
     *
     */
    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes==null){
            return;
        }
        
        for (int i=0;i<activatedNodes.length;i++){
            Node node = activatedNodes[i];
            Lookup lookup = node.getLookup();
            Object obj = lookup.lookup(Enableable.class);
            
            try {
                if(obj instanceof Enableable) {
                    Enableable enableableObj = (Enableable)obj;
                    if(enableableObj.isEnabled()) {
                        enableableObj.setEnabled(false);
                        enabled = false;
                    } else {
                        enableableObj.setEnabled(true);
                        enabled = true;
                    }
                }
            } catch(java.lang.RuntimeException rex) {
                ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL,rex);
            }
            
            Node parentNode = node.getParentNode();
            RefreshCookie refreshAction =
                    (RefreshCookie)parentNode.getCookie(RefreshCookie.class);
            if (refreshAction != null){
                refreshAction.refresh();
            }
        }
        
    }
    
    
    /**
     *
     *
     */
    protected boolean enable(Node[] nodes) {
        if(nodes.length > 0) {
            Node node = nodes[0];
            Lookup lookup = node.getLookup();
            Object obj = lookup.lookup(Enableable.class);
            
            try {
                if(obj instanceof Enableable) {
                    Enableable enableableObj = (Enableable)obj;
                    if(enableableObj.isEnabled()) {
                        enabled = false;
                    } else {
                        enabled = true;
                    }
                }
            } catch(java.lang.RuntimeException rex) {
                ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL,rex);
            }
        }
        
        return ((nodes != null) && (nodes.length >= 1)) ? true : false;
    }
    
    
    /**
     *
     *
     */
    protected boolean asynchronous() {
        return false;
    }
    
    
    /**
     *
     *
     */
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    
    /**
     *
     */
    public String getName() {
        if(enabled) {
            return NbBundle.getMessage(EnableDisableAction.class, "LBL_EnableAction");
        } else {
            return NbBundle.getMessage(EnableDisableAction.class, "LBL_DisableAction");
        }
    }
    
}
