/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.ide.runtime.nodes;

import java.util.List;
import java.util.Arrays;

import javax.swing.Action;
import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtLeafNode;
import org.openide.util.actions.SystemAction;

import org.netbeans.modules.j2ee.sun.ide.controllers.AppClientModuleController;
import org.netbeans.modules.j2ee.sun.ide.controllers.DeployedItemsController;
import org.netbeans.modules.j2ee.sun.util.NodeTypes;
import org.netbeans.modules.j2ee.sun.ide.runtime.actions.UndeployAction;
import org.netbeans.modules.j2ee.sun.bridge.apis.Undeployable;
import org.openide.actions.PropertiesAction;




/**
 */
public class AppClientModuleNode extends AppserverMgmtLeafNode 
        implements Undeployable {
        
    private static String NODE_TYPE = NodeTypes.APP_CLIENT_MODULE;
    private String appClientName;
    private boolean isEmbedded;
            

    
    
    /**
     *
     *
     */
    public AppClientModuleNode(AppClientModuleController controller) {
        super(controller,NODE_TYPE);
        this.appClientName = controller.getName();
        this.isEmbedded = isEmbedded;
        setDisplayName(appClientName);
    }
    
    
    /**
     *
     *
     */
    public AppClientModuleNode(final AppClientModuleController controller,
            final boolean isEmbedded) {
        super(controller,NODE_TYPE);
        this.appClientName = controller.getName();
        this.isEmbedded = isEmbedded;
        setDisplayName(appClientName);

    }
    
    public AppClientModuleNode(final String name) {
        super(NODE_TYPE);
        this.isEmbedded = true;
        setDisplayName(name);
    }
    
    /**
     * Return the actions associated with the menu drop down seen when
     * a user right-clicks on an Applications node in the plugin.
     *
     * @param boolean true/false
     * @return An array of Action objects.
     */
    public Action[] getActions(boolean flag) {
        if(!isEmbedded) {
            return new SystemAction[] {
                SystemAction.get(UndeployAction.class),
                SystemAction.get(PropertiesAction.class)
            };
        } else {
            return new SystemAction[] {
                SystemAction.get(PropertiesAction.class)
            };
        }
    }
    
    
    /**
     * Return the SheetProperties to be displayed for this Application Client
     * Module.
     *
     * @return A java.util.Map containing all app client module properties.
     */
    protected java.util.Map getSheetProperties() {
       return getController().getProperties(getPropertiesToIgnore()); 
    }
      
    
    /**
     * Sets the property as an attribute to the underlying AMX mbeans. It 
     * usually will delegate to the controller object which is responsible for
     * finding the correct AMX mbean objectname in order to execute a 
     * JMX setAttribute.
     *
     * @param attrName The name of the property to be set.
     * @param value The value retrieved from the property sheet to be set in the
     *        backend.
     * @returns the updated Attribute accessed from the Sheet
     */
    public javax.management.Attribute setSheetProperty(String attrName, Object value) {
        return getController().setProperty(attrName, value);
    }
    
    
    /**
     *
     *
     */
    public void undeploy() {
        ((DeployedItemsController)getController()).undeploy();
    }
    
    protected List getPropertiesToIgnore() {
        return Arrays.asList(NodeTypes.APP_CLIENT_MODULES_NODE);        
    }
}
