/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.ide.runtime.nodes;

import java.util.List;
import java.util.Arrays;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.sun.ide.controllers.ControllerUtil;

import com.sun.appserv.management.base.Util;
import org.netbeans.modules.j2ee.sun.util.NodeTypes;
import org.netbeans.modules.j2ee.sun.ide.controllers.ConnectorModuleController;
import org.openide.nodes.Children;
import org.openide.nodes.Node;




/**
 */
public class ConnectorModuleNode extends AppserverMgmtApplicationsNode {
        
    private static String NODE_TYPE = NodeTypes.CONNECTOR_MODULE;       
    
    /**
     *
     *
     */
    public ConnectorModuleNode(final ConnectorModuleController controller,
            final boolean isEmbedded) {
        super(getChildNodes(controller), controller, NODE_TYPE, isEmbedded);
        setDisplayName(controller.getName());
    }

    
    /**
     *
     *
     */
    public ConnectorModuleNode(final ConnectorModuleController controller) {
        super(getChildNodes(controller), controller, NODE_TYPE, false);
        setDisplayName(controller.getName());
    }
    
    public ConnectorModuleNode(final String name) {
        super(Children.LEAF, null, NODE_TYPE, true);
        setDisplayName(name);
    }
    
    /**
     *
     */
    static Children getChildNodes(ConnectorModuleController controller) {
        return createConnectorModuleNodeChildren(controller);
    }
    
    
    /**
     *
     */
    static Children createConnectorModuleNodeChildren(
            ConnectorModuleController controller) {
        Children children = new Children.Array();
        java.util.Vector nodes = new java.util.Vector();
        
        //create all embedded servlets
        if(controller.getJ2EEObject() != null){
            //create all the resource adapters
            String [] names = controller.getResourceAdaptors();
            if(names != null || names.length > 0) {
                for(int i = 0; i < names.length; i++) {
                    nodes.add(new ResourceAdapterNode(controller, names[i]));
                }
            }
        }else{
            ObjectName[] subComponents = ControllerUtil.getSubComponentsFromConfig(controller.getName(), controller.getMBeanServerConnection());
            for(int i=0; i<subComponents.length; i++){
                ObjectName oname = subComponents[i];
                String name = Util.getName(oname);
                nodes.add(new ResourceAdapterNode(name));
            };
        }
        
        Node[] arrayToAdd = new Node[nodes.size()];
        children.add((Node[])nodes.toArray(arrayToAdd));
        return children;  
    }
    
    protected List getPropertiesToIgnore() {
        return Arrays.asList(NodeTypes.CONNECTOR_MODULE_NODE);        
    }
}
