/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.ide.runtime.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.Action;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtContainerNode;
import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtController;
import org.openide.util.actions.SystemAction;

import org.netbeans.modules.j2ee.sun.util.NodeTypes;
import org.netbeans.modules.j2ee.sun.ide.controllers.ControllerUtil;

import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.sun.util.PropertySupportFactory;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;

/**
 */
public class DomainRootNode extends AppserverMgmtContainerNode  implements  PropertyChangeListener{
    
    private static final String NODE_TYPE = NodeTypes.DOMAIN;
    private PropertySupportFactory propSupportFactory = 
                PropertySupportFactory.getInstance();
    private DeploymentManager deployMgr;
    
    
    /**
     *
     */
    public DomainRootNode(final DeploymentManager dm) {
        super(null, NODE_TYPE);
        deployMgr  =dm;
        SunDeploymentManagerInterface sdm=(SunDeploymentManagerInterface)deployMgr;
        sdm.addPropertyChangeListener(this);
        /*
         this is to make sure classes are loaded in IDE classloader if
         user runs an app from the projects tab
        */
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                 refresh();
            }
        });
        
        shutOffJMXAndAMXLogging();
    }
    
    public void refresh(){
        SunDeploymentManagerInterface sdm=(SunDeploymentManagerInterface)deployMgr;
        if (sdm.isSuspended()) {
            return;
        }
        if (sdm.grabInnerDM(true)) {
            try {
                AppserverMgmtController a= ControllerUtil.getAppserverMgmtControllerFromDeployMgr( deployMgr);
                setAppserverMgmtController(a);
                super.refresh();
            } finally {
                sdm.releaseInnerDM();
            }
        } else {
            javax.swing.SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    refresh();
                }
            });
        }
    }    
    /**
     * Return the actions associated with the menu drop down seen when
     * a user right-clicks on an the node in the plugin. This method here
     * is overidden to eliminate duplicate refresh options at the server
     * node level.
     *
     * @param boolean true/false
     * @return An array of Action objects.
     */
    public Action[] getActions(boolean flag) {
        return new SystemAction[] {};
    }
    
    /**
     * Creates a properties Sheet for viewing when a user chooses the option
     * from the right-click menu.
     *
     * @returns the Sheet to display when Properties is chosen by the user.
     */
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        ClassLoader origClassLoader=Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(
                    this.getClass().getClassLoader());
            Sheet.Set props = sheet.get(Sheet.PROPERTIES);
            props.put(createPropertySupportArray(getSheetProperties()));
            return sheet;
        } catch(RuntimeException rex) {
            rex.printStackTrace();
            return sheet;
        } finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }
    
    /**
     * Creates a PropertySupport array from a map of component properties.
     *
     * @param properties The properties of the component.
     * @return An array of PropertySupport objects.
     */
    PropertySupport[] createPropertySupportArray(final java.util.Map attrMap) {
        PropertySupport[] supports = new PropertySupport[attrMap.size()];
        int i = 0;
        for(Iterator itr = attrMap.keySet().iterator(); itr.hasNext(); ) {
            Attribute attr = (Attribute) itr.next();
            MBeanAttributeInfo info = (MBeanAttributeInfo) attrMap.get(attr);
            supports[i] = 
                propSupportFactory.createLogLevelProperty(this, attr, info);
            i++;
        }
        return supports; 
    }
    
   /**
     * Return the SheetProperties to be displayed for the Domain Node
     *
     * @return A java.util.Map containing all Log levels
    */
    java.util.Map getSheetProperties() {
        return getAppserverMgmtController().getLogProperties("server"); //NOI18N 
    }
    
    /**
     * Sets the property as an attribute to the underlying AMX mbeans. It 
     * usually will delegate to the controller object which is responsible for
     * finding the correct AMX mbean objectname in order to execute a 
     * JMX setAttribute.
     *
     * @param attrName The name of the property to be set.
     * @param value The value retrieved from the property sheet to be set in the
     *        backend.
     * @returns the updated Attribute accessed from the Sheet.
     */
    public javax.management.Attribute setSheetProperty(String attrName, Object value) {
        try {
            return getAppserverMgmtController().setLogProperties("server", attrName, value); //NOI18N
        } catch (RuntimeException rex) {
            return null;
        }
    }
    
    /**
     *
     *
     */
    private void shutOffJMXAndAMXLogging() {
        //local logger
        
        java.util.logging.Logger.getLogger(
                "org.netbeans.modules.j2ee.sun").
                        setLevel(java.util.logging.Level.OFF);
        
        //amx loggers
        java.util.logging.Logger.getLogger(
                "javax.enterprise.system.tools.admin").
                        setLevel(java.util.logging.Level.OFF);
        java.util.logging.Logger.getLogger(
                "javax.enterprise.system.tools.admin.client").
                        setLevel(java.util.logging.Level.OFF);
        java.util.logging.Logger.getLogger(
                "javax.enterprise.system.tools.admin.server").
                        setLevel(java.util.logging.Level.OFF);
        java.util.logging.Logger.getLogger(
                "javax.enterprise.system.tools.admin.server.mbeans").
                        setLevel(java.util.logging.Level.OFF);
        
        //jmx remote logger
        java.util.logging.Logger.getLogger(
                "javax.management.remote").
                        setLevel(java.util.logging.Level.OFF);
    }

    public void propertyChange(PropertyChangeEvent evt) {

        
        //setAppserverMgmtController(ControllerUtil.getAppserverMgmtControllerFromDeployMgr( deployMgr));
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                refresh();
            }
        });
    }
    


}
