/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.ide.runtime.nodes;

import java.util.List;
import java.util.Arrays;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.sun.ide.controllers.ControllerUtil;
import org.netbeans.modules.j2ee.sun.util.NodeTypes;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.j2ee.EntityBean;
import com.sun.appserv.management.j2ee.MessageDrivenBean;
import com.sun.appserv.management.j2ee.StatefulSessionBean;
import com.sun.appserv.management.j2ee.StatelessSessionBean;
import org.netbeans.modules.j2ee.sun.ide.controllers.EJBModuleController;
import org.openide.nodes.Children;
import org.openide.nodes.Node;




/**
 */
public class EJBModuleNode extends AppserverMgmtApplicationsNode {
        
    private static String NODE_TYPE = NodeTypes.EJB_MODULE;
      
    /**
     *
     */
    public EJBModuleNode(final EJBModuleController controller,
            final boolean isEmbedded) {
        super(getChildNodes(controller), controller, NODE_TYPE, isEmbedded);
        setDisplayName(controller.getName());
    }
    
    
    /**
     *
     */
    public EJBModuleNode(final EJBModuleController controller) {
        super(getChildNodes(controller), controller, NODE_TYPE, false);
        setDisplayName(controller.getName());
    }
    
    public EJBModuleNode(final String name) {
        super(Children.LEAF, null, NODE_TYPE, true);
        setDisplayName(name);
    }
    
    /**
     *
     */
    static Children getChildNodes(EJBModuleController controller) {
        return createEJBModuleNodeChildren(controller);
    }
    
    
    /**
     *
     */
    static Children createEJBModuleNodeChildren(EJBModuleController controller) {
        
        Children children = new Children.Array();
        java.util.Vector nodes = new java.util.Vector();

        if(controller.getJ2EEObject() != null){
            //create all embedded stateless ejbs
            String [] statelessNames = controller.getStatelessSessionBeans();
            if(statelessNames != null || statelessNames.length > 0) {
                for(int i = 0; i < statelessNames.length; i++) {
                    nodes.add(new StatelessEjbNode(
                            controller, statelessNames[i]));
                }
            }
            
            //create all embedded stateful ejbs
            String [] statefulNames = controller.getStatefulSessionBeans();
            if(statefulNames != null || statefulNames.length > 0) {
                for(int i = 0; i < statefulNames.length; i++) {
                    nodes.add(new StatefulEjbNode(
                            controller, statefulNames[i]));
                }
            }
            
            //create all embedded message driven ejbs
            String [] messageDrivenNames = controller.getMessageDrivenBeans();
            if(messageDrivenNames != null || messageDrivenNames.length > 0) {
                for(int i = 0; i < messageDrivenNames.length; i++) {
                    nodes.add(new MessageDrivenEjbNode(
                            controller, messageDrivenNames[i]));
                }
            }
            
            //create all embedded entity ejbs
            String [] entityBeans = controller.getEntityBeans();
            if(entityBeans != null || entityBeans.length > 0) {
                for(int i = 0; i < entityBeans.length; i++) {
                    nodes.add(new EntityEjbNode(
                            controller, entityBeans[i]));
                }
            }
        }else{
            ObjectName[] subComponents = ControllerUtil.getSubComponentsFromConfig(controller.getName(), controller.getMBeanServerConnection());
            for(int i=0; i<subComponents.length; i++){
                ObjectName oname = subComponents[i];
                String type = Util.getJ2EEType(oname);
                String name = Util.getName(oname);
                if(EntityBean.J2EE_TYPE.equals(type)){
                    nodes.add(new EntityEjbNode(name));
                }else if(MessageDrivenBean.J2EE_TYPE.equals(type)){
                    nodes.add(new MessageDrivenEjbNode(name)); 
                }else if (StatefulSessionBean.J2EE_TYPE.equals(type)){
                    nodes.add(new StatefulEjbNode(name));
                }else if(StatelessSessionBean.J2EE_TYPE.equals(type)){
                    nodes.add(new StatelessEjbNode(name));
                }
            };
        }
        
        Node[] arrayToAdd = new Node[nodes.size()];
        children.add((Node[])nodes.toArray(arrayToAdd));
        return children;  
    }
    
    protected List getPropertiesToIgnore() {
        return Arrays.asList(NodeTypes.EJB_MODULE_NODE);        
    }
}
