/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.util;

import java.util.Set;
import java.io.IOException;


import com.sun.appserv.management.util.jmx.MBeanServerConnection_Hook;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;

import org.openide.util.NbBundle;

/**
 *
 */
public class PluginRequestInterceptor 
        extends MBeanServerConnection_Hook {
    
    final MBeanServerConnection_Hook.Hook myHook;
    
    /**
     *
     *
     */
    public PluginRequestInterceptor(
            final SunDeploymentManagerInterface sunDplymtIntrface,
            final MBeanServerConnection connection) {
        super(connection);
        this.myHook = new DebugCheckerHook(sunDplymtIntrface);
    }
    

    /**
     *
     *
     */
    Hook getHook() {
        return this.myHook;
    }
    
    
    /**
     *
     */
    public void setAttribute(ObjectName name, Attribute attribute)
            throws InstanceNotFoundException, AttributeNotFoundException,
            InvalidAttributeValueException, MBeanException,
            ReflectionException, IOException {
        getHook().preHook(null);
        super.setAttribute(name, attribute);
    }


    /**
     *
     *
     */
    public AttributeList setAttributes(ObjectName name, AttributeList attributes)
            throws InstanceNotFoundException, ReflectionException, IOException {    
       getHook().preHook(null);
       return super.setAttributes(name, attributes);
    }
     
    
    /**
     *
     *
     */
    public Object getAttribute(ObjectName name, String attribute)
            throws MBeanException, AttributeNotFoundException,
            InstanceNotFoundException, ReflectionException,
            IOException {         
        getHook().preHook(null);
        return super.getAttribute(name, attribute);
    }


    /**
     *
     */
    public AttributeList getAttributes(ObjectName name, String[] attributes)
            throws InstanceNotFoundException, ReflectionException,
            IOException {
        getHook().preHook(null);
        return super.getAttributes(name, attributes);
    }
     
     
    /**
     *
     */
    public MBeanInfo getMBeanInfo(ObjectName name)
            throws InstanceNotFoundException, IntrospectionException,
            ReflectionException, IOException {
        getHook().preHook(null);
        return super.getMBeanInfo(name);
    }

     
    
    /**
     *
     *
     */
    public Object invoke(ObjectName name, String operationName,
            Object params[], String signature[])
            throws InstanceNotFoundException, MBeanException,
            ReflectionException, IOException {
       getHook().preHook(null);
       return super.invoke(name, operationName, params, signature);
    }

    
    /**
     *
     *
     */
    public Set queryNames(ObjectName name, QueryExp query)
            throws IOException {
        getHook().preHook(null);
        return super.queryNames(name, query);
    }

    
    /**
     *
     *
     */
    public Set queryMBeans(ObjectName name, QueryExp query)
            throws IOException {
        getHook().preHook(null);
        return super.queryMBeans(name, query);
    }
    
    
    /**
     *
     *
     */
    class DebugCheckerHook extends MBeanServerConnection_Hook.HookImpl {

        private SunDeploymentManagerInterface sunDpmtMgr;
        
        /**
         *
         */
        public DebugCheckerHook(
                final SunDeploymentManagerInterface sunDplymtIntrface) {  
            this.sunDpmtMgr = sunDplymtIntrface;
        }

        
        /**
         *
         */
        public long preHook(final String methodName) {
            return preHook(methodName, new Object[] {});
        }

        
        /**
         * 
         */
        public long preHook(final String methodName, final Object[] args) {
            if(sunDpmtMgr.isSuspended()) {
                GUIUtils.showInformation(
                    getLocalizedString("server_dbg_mode_notify"));
                throw new RuntimeException(
                    getLocalizedString("server_dbg_mode_notify"));
            } 
            return super.preHook(methodName, args);
        }
        
    } //end inner class
    
         
    /**
     *
     *
     */
    private static String getLocalizedString(final String bundleStrProp) {
        return NbBundle.getMessage(PluginRequestInterceptor.class, 
                bundleStrProp);
    }
}
