/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.hk2.customizer;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.hk2.ide.Hk2PluginProperties;


/**
 *
 * @author Ludo
 */
public class CustomizerUserPanel extends javax.swing.JPanel {
    
    private InstanceProperties ip;
    
    /**
     * Creates new form CustomizerUserPanel
     */
    public CustomizerUserPanel(final InstanceProperties ip) {
        this.ip = ip;
        
        initComponents();
        
        setInitValues();
        
        usersComboBox.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent event) {
                if(!ip.getProperty(InstanceProperties.USERNAME_ATTR).equals(event.getItem())) {
                    ip.setProperty(InstanceProperties.USERNAME_ATTR, (String) event.getItem());
                    changePassword();
                }
            }
        });
    }
    
    private void setInitValues() {
        String j2eeLocalHome = ip.getProperty(Hk2PluginProperties.PROPERTY_HK2_HOME);
        
    }
    
    private void changePassword() {
        String username = ip.getProperty(InstanceProperties.USERNAME_ATTR);
        String password = null;/////requestPassword(username);
        
        if(password != null)
            ip.setProperty(InstanceProperties.PASSWORD_ATTR, password);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        userLabel = new javax.swing.JLabel();
        usersComboBox = new javax.swing.JComboBox();
        changeButton = new javax.swing.JButton();

        userLabel.setText(org.openide.util.NbBundle.getMessage(CustomizerUserPanel.class, "LBL_UserPanel")); // NOI18N

        changeButton.setText(org.openide.util.NbBundle.getMessage(CustomizerUserPanel.class, "LBL_UserChange")); // NOI18N
        changeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                changeButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(userLabel)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(usersComboBox, 0, 212, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(changeButton)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(userLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(changeButton)
                    .add(usersComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
private void changeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_changeButtonActionPerformed
    changePassword();
}//GEN-LAST:event_changeButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton changeButton;
    private javax.swing.JLabel userLabel;
    private javax.swing.JComboBox usersComboBox;
    // End of variables declaration//GEN-END:variables
    
}
