/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * WebAppGeneralPanel.java
 *
 * Created on November 5, 2003, 4:56 PM
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.util.ArrayList;
import java.util.ResourceBundle;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import org.netbeans.modules.j2ee.sun.dd.api.web.JspConfig;
import org.netbeans.modules.j2ee.sun.dd.api.web.SunWebApp;
import org.netbeans.modules.j2ee.sun.dd.api.web.WebProperty;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;

import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BaseCustomizer;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.HelpContext;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.DynamicPropertyPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyListMapping;


/**
 *
 * @author Peter Williams
 */
public class WebAppGeneralPanel extends javax.swing.JPanel implements TableModelListener {
	
	private static final ResourceBundle webappBundle = ResourceBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");	// NOI18N

	private static final ResourceBundle commonBundle = ResourceBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");	// NOI18N

	private WebAppRootCustomizer masterPanel;

	// Table for editing JspConfig web properties
	private GenericTableModel jspConfigModel;
	private GenericTablePanel jspConfigPanel;

	// Table for editing Property web properties
	private GenericTableModel propertiesModel;
	private GenericTablePanel propertiesPanel;

    // true if AS 8.1+ fields are visible.
    private boolean as81FeaturesVisible;
    
    // true if AS 9.0+ fields are visible.
    private boolean as90FeaturesVisible;
    
	/** Creates new form WebAppGeneralPanel */
	public WebAppGeneralPanel(WebAppRootCustomizer src) {
		masterPanel = src;

		initComponents();
		initUserComponents();		
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLblContextRoot = new javax.swing.JLabel();
        jTxtContextRoot = new javax.swing.JTextField();
        jLblErrorUrl = new javax.swing.JLabel();
        jTxtErrorUrl = new javax.swing.JTextField();
        jLblHttpservletSecurityProvider = new javax.swing.JLabel();
        jTxtHttpservletSecurityProvider = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_WebAppGeneralTab"));
        getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_WebAppGeneralTab"));
        jLblContextRoot.setLabelFor(jTxtContextRoot);
        jLblContextRoot.setText(webappBundle.getString("LBL_ContextRoot_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        add(jLblContextRoot, gridBagConstraints);

        jTxtContextRoot.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTxtContextRootKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(jTxtContextRoot, gridBagConstraints);
        jTxtContextRoot.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_ContextRoot"));
        jTxtContextRoot.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_ContextRoot"));

        jLblErrorUrl.setLabelFor(jTxtErrorUrl);
        jLblErrorUrl.setText(webappBundle.getString("LBL_ErrorUrl_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        add(jLblErrorUrl, gridBagConstraints);

        jTxtErrorUrl.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTxtErrorUrlKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(jTxtErrorUrl, gridBagConstraints);

        jLblHttpservletSecurityProvider.setLabelFor(jTxtHttpservletSecurityProvider);
        jLblHttpservletSecurityProvider.setText(webappBundle.getString("LBL_HttpservletSecurityProvider_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        add(jLblHttpservletSecurityProvider, gridBagConstraints);

        jTxtHttpservletSecurityProvider.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTxtHttpservletSecurityProviderKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        add(jTxtHttpservletSecurityProvider, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void jTxtHttpservletSecurityProviderKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTxtHttpservletSecurityProviderKeyReleased
        WebAppRoot bean = masterPanel.getBean();
		if(bean != null) {
			try {
				bean.setHttpservletSecurityProvider(jTxtHttpservletSecurityProvider.getText());
//				masterPanel.validateField(WebAppRoot.FIELD_HTTP_SERVLET_SECURITY_PROVIDER);
			} catch(java.beans.PropertyVetoException exception) {
				jTxtHttpservletSecurityProvider.setText(bean.getHttpservletSecurityProvider());
			}
		}
    }//GEN-LAST:event_jTxtHttpservletSecurityProviderKeyReleased

    private void jTxtErrorUrlKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTxtErrorUrlKeyReleased
        WebAppRoot bean = masterPanel.getBean();
		if(bean != null) {
			try {
				bean.setErrorUrl(jTxtErrorUrl.getText());
//				masterPanel.validateField(WebAppRoot.FIELD_ERROR_URL);
			} catch(java.beans.PropertyVetoException exception) {
				jTxtErrorUrl.setText(bean.getErrorUrl());
			}
		}
    }//GEN-LAST:event_jTxtErrorUrlKeyReleased

	private void jTxtContextRootKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTxtContextRootKeyReleased
        WebAppRoot bean = masterPanel.getBean();
		if(bean != null) {
			try {
				bean.setContextRoot(jTxtContextRoot.getText());
//				masterPanel.validateField(WebAppRoot.FIELD_CONTEXT_ROOT);
			} catch(java.beans.PropertyVetoException exception) {
				jTxtContextRoot.setText(bean.getContextRoot());
			}
		}
	}//GEN-LAST:event_jTxtContextRootKeyReleased
	
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLblContextRoot;
    private javax.swing.JLabel jLblErrorUrl;
    private javax.swing.JLabel jLblHttpservletSecurityProvider;
    private javax.swing.JTextField jTxtContextRoot;
    private javax.swing.JTextField jTxtErrorUrl;
    private javax.swing.JTextField jTxtHttpservletSecurityProvider;
    // End of variables declaration//GEN-END:variables
	
	private void initUserComponents() {
            
		as81FeaturesVisible = true;
		as90FeaturesVisible = true;
        
		/** Add call properties table panel :
		 *  TableEntry list has three properties: Name, Value, Description
		 */
		ArrayList tableColumns = new ArrayList(3);
		tableColumns.add(new GenericTableModel.AttributeEntry(
			WebProperty.NAME, commonBundle.getString("LBL_Name"), true));	// NOI18N
		tableColumns.add(new GenericTableModel.AttributeEntry(
			WebProperty.VALUE, commonBundle.getString("LBL_Value"), true));	// NOI18N
		tableColumns.add(new GenericTableModel.ValueEntry(
			WebProperty.DESCRIPTION, commonBundle.getString("LBL_Description")));	// NOI18N		
		
		// add JspConfig table
		jspConfigModel = new GenericTableModel(JspConfig.PROPERTY, WebAppRootCustomizer.webPropertyFactory, tableColumns);
		jspConfigPanel = new GenericTablePanel(jspConfigModel, 
			webappBundle, "JspConfigProperties",	// NOI18N - property name
			DynamicPropertyPanel.class, HelpContext.HELP_WEBAPP_JSPCONFIG_POPUP,
			PropertyListMapping.getPropertyList(PropertyListMapping.WEBAPP_JSPCONFIG_PROPERTIES));
		
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 5);
		add(jspConfigPanel, gridBagConstraints);		
		
		// add Properties table
        propertiesModel = new GenericTableModel(WebAppRootCustomizer.webPropertyFactory, tableColumns);
		propertiesPanel = new GenericTablePanel(propertiesModel, 
			webappBundle, "WebProperties",	// NOI18N - property name
			DynamicPropertyPanel.class, HelpContext.HELP_WEBAPP_PROPERTY_POPUP,
			PropertyListMapping.getPropertyList(PropertyListMapping.WEBAPP_PROPERTIES));
		
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 5);
		add(propertiesPanel, gridBagConstraints);
	}
	
	public void addListeners() {
		jspConfigModel.addTableModelListener(this);
		propertiesModel.addTableModelListener(this);
	}
	
	public void removeListeners() {
		propertiesModel.removeTableModelListener(this);
		jspConfigModel.removeTableModelListener(this);
	}
	
	/** Initialization of all the fields in this panel from the bean that
	 *  was passed in.
	 */
	public void initFields(WebAppRoot bean) {
        ASDDVersion asVersion = bean.getAppServerVersion();

		jspConfigPanel.setModel(bean.getJspConfig(), asVersion);
		propertiesPanel.setModel(bean.getProperties(), asVersion);

        if(ASDDVersion.SUN_APPSERVER_8_1.compareTo(bean.getAppServerVersion()) <= 0) {
            showAS81Fields();
    		jTxtContextRoot.setText(bean.getContextRoot());
            jTxtErrorUrl.setText(bean.getErrorUrl());
        } else {
            hideAS81Fields();
        }
        
        if(ASDDVersion.SUN_APPSERVER_9_0.compareTo(bean.getAppServerVersion()) <= 0) {
            showAS90Fields();
    		jTxtHttpservletSecurityProvider.setText(bean.getHttpservletSecurityProvider());
        } else {
            hideAS90Fields();
        }
        
	}	
        
    // TODO after 5.0, generalize version based field display for multiple (> 2)
    // appserver versions.  (!PW note: this is the first panel to have changes across
    // 3 revisions of the relevant DTD.)
    //
    // Generalization idea: Tag each control a "MinVersion" property whose value is the instance
    // of AsDDVersion that corresponds with the needed appserver version.  Could later tag
    // with "MaxVersion", or even "ExcludeVersion", if necessary.
    //
    private void showAS81Fields() {
        if(!as81FeaturesVisible) {
            jLblContextRoot.setVisible(true);
            jTxtContextRoot.setVisible(true);
            jLblErrorUrl.setVisible(true);
            jTxtErrorUrl.setVisible(true);
            
            as81FeaturesVisible = true;
        }
    }
    
    private void hideAS81Fields() {
        if(as81FeaturesVisible) {
            jLblContextRoot.setVisible(false);
            jTxtContextRoot.setVisible(false);
            jLblErrorUrl.setVisible(false);
            jTxtErrorUrl.setVisible(false);
            
            as81FeaturesVisible = false;
        }
    }
	
    private void showAS90Fields() {
        if(!as90FeaturesVisible) {
            jLblHttpservletSecurityProvider.setVisible(true);
            jTxtHttpservletSecurityProvider.setVisible(true);
            
            as90FeaturesVisible = true;
        }
    }
    
    private void hideAS90Fields() {
        if(as90FeaturesVisible) {
            jLblHttpservletSecurityProvider.setVisible(false);
            jTxtHttpservletSecurityProvider.setVisible(false);
            
            as90FeaturesVisible = false;
        }
    }

    /** ----------------------------------------------------------------------- 
	 *  Implementation of javax.swing.event.TableModelListener
	 */
	public void tableChanged(TableModelEvent e) {
		WebAppRoot bean = masterPanel.getBean();
		if(bean != null) {
			try {
				Object eventSource = e.getSource();
				if(eventSource == jspConfigModel) {
					// This statement will not produce a change event because
					// of the way we handle property storage for properties like
					// this one.  (The JspConfig we're modifying already is the
					// one owned by the bean).
					//
//					bean.setJspConfig((JspConfig) jspConfigModel.getDataBaseBean());
				} else if(eventSource == propertiesModel) {
					bean.setProperties(propertiesModel.getData());
				}
				
				// Force property change to be issued by the bean
				bean.setDirty();
			} catch(PropertyVetoException ex) {
				// FIXME undo whatever changed... how?
			}
		}
	}
}
