/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * ServiceRefCustomizer.java
 *
 * Created on September 4, 2003, 5:28 PM
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.util.ResourceBundle;

import java.beans.Customizer;
import java.beans.PropertyVetoException;

import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.netbeans.modules.j2ee.sun.share.configbean.ServiceRef;
import org.netbeans.modules.j2ee.sun.share.configbean.ErrorMessageDB;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.CustomizerErrorPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.CustomizerTitlePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BaseCustomizer;


/**
 *
 * @author Peter Williams
 */
public class ServiceRefCustomizer extends BaseCustomizer {

    static final ResourceBundle bundle = ResourceBundle.getBundle(
            "org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle"); // NOI18N

	/** The bean currently being customized, or null if there isn't one
	 */
	private ServiceRef theBean;

	/** The two tabbed panels */
	private ServiceRefGeneralPanel generalPanel;
	private ServiceRefPortInfoPanel portInfoPanel;

	/** Creates new form ServiceRefCustomizer */
	public ServiceRefCustomizer() {
		initComponents();
		initUserComponents();
	}

	public ServiceRef getBean() {
		return theBean;
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        serviceRefTabbedPanel = new javax.swing.JTabbedPane();

        setLayout(new java.awt.GridBagLayout());

        serviceRefTabbedPanel.setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(serviceRefTabbedPanel, gridBagConstraints);

    }//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTabbedPane serviceRefTabbedPanel;
    // End of variables declaration//GEN-END:variables

	private void initUserComponents() {
		// Add title panel
		addTitlePanel(bundle.getString("TITLE_ServiceRef"));
		getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ServiceRef"));	// NOI18N
		getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ServiceRef"));	// NOI18N

		// add general panel
		generalPanel = new ServiceRefGeneralPanel(this);
		serviceRefTabbedPanel.addTab(bundle.getString("TAB_General"), generalPanel);	// NOI18N

		// add port info panel
		portInfoPanel = new ServiceRefPortInfoPanel(this);
		serviceRefTabbedPanel.addTab(bundle.getString("TAB_PortInfo"), portInfoPanel);	// NOI18N

		// Add error panel
		addErrorPanel();
	}

	protected void initFields() {
		generalPanel.initFields(theBean);
		portInfoPanel.initFields(theBean);
	}

	public void partitionStateChanged(ErrorMessageDB.PartitionState oldState, ErrorMessageDB.PartitionState newState) {
		if(newState.getPartition() == getPartition()) {
			showErrors();
		}

		if(oldState.hasMessages() != newState.hasMessages()) {
			serviceRefTabbedPanel.setIconAt(newState.getPartition().getTabIndex(), newState.hasMessages() ? panelErrorIcon : null);
		}
	}

	protected void addListeners() {
		super.addListeners();
		generalPanel.addListeners(theBean);
		portInfoPanel.addListeners(theBean);
	}
	
	protected void removeListeners() {
		super.removeListeners();
		generalPanel.removeListeners(theBean);
		portInfoPanel.removeListeners(theBean);
	}	
	
	protected boolean setBean(Object bean) {
		boolean result = super.setBean(bean);

		if(bean instanceof ServiceRef) {
			theBean = (ServiceRef) bean;
			result = true;
		} else {
			// if bean is not a ServiceRef, then it shouldn't have passed Base either.
			assert (result == false) :
				"ServiceRefCustomizer was passed wrong bean type in setBean(Object bean)";	// NOI18N

			theBean = null;
			result = false;
		}

		return result;
	}

	public String getHelpId() {
		String result = "AS_CFG_ServiceRefGeneral";	// NOI18N

		// Determine which tab has focus and return help context for that tab.
		switch(serviceRefTabbedPanel.getSelectedIndex()) {
			case 1:
				result = "AS_CFG_ServiceRefPortInfo";	// NOI18N
				break;
		}

		return result;
	}

	/** Retrieve the partition that should be associated with the current
	 *  selected tab.
	 *
	 *  @return ValidationError.Partition
	 */
	public ValidationError.Partition getPartition() {
		switch(serviceRefTabbedPanel.getSelectedIndex()) {
			case 1:
				return ValidationError.PARTITION_SERVICEREF_PORTINFO;
			default:
				return ValidationError.PARTITION_SERVICEREF_GENERAL;
		}
	}
}
