/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.weblogic9.util;

/**
 * The central debugging utility for the plugin. The plugin whould forward all
 * the debugging information to this tool, which will output it to System.err
 * if the debug has been enabled
 *
 * @author Kirill Sorokin
 */
public class WLDebug {
    
    /**
     * Indicated whether the debug is enabled. At initialization we check for 
     * the presence of the "j2eeplugins.weblogic9" property and if it is 
     * present we consider the debug for the plugin enabled.
     */
    private static boolean isEnabled = System.getProperty("j2eeplugins.weblogic9.debug") != null; // NOI18N
    
    /**
     * Tells whether the debug for the plugin is enabled
     */
    public static boolean isEnabled() {
        return isEnabled;
    }
    
    /**
     * Outputs the given message to the System.err with the fixed prefix
     *
     * @param message the message to be output
     */
    public static void notify(String message) {
        System.err.println("j2eeplugins.weblogic9 --- " + message); // NOI18N
    }
    
    /**
     * Outputs the given message to the System.err with the fixed prefix and the
     * class name
     * 
     * @param clazz the class from which the message originated
     * @param message the message to be output
     */
    public static void notify(Class clazz, String message) {
        System.err.println("j2eeplugins.weblogic9 --- [" + clazz.getName() + "]: " + message); // NOI18N
    }
    
    /**
     * Prints the current stack to the System.err
     */
    public static void printStack() {
        StackTraceElement[] stack = new Exception().getStackTrace();
        
        for (int i = 3; i < stack.length; i++) {
            System.err.println("j2eeplugins.weblogic9 --- " + stack[i]); // NOI18N
        }
    }
    
}
