/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.core.export;

import java.io.File;
import javax.swing.JFileChooser;
import org.netbeans.modules.tasklist.core.util.SimpleWizardPanel;
import org.openide.util.NbBundle;

/**
 * Panel with a file chooser
 */
public class OpenFilePanel extends javax.swing.JPanel {
    private SimpleWizardPanel panel;
    
    /** Creates new form ChooseFilePanel */
    public OpenFilePanel() {
        initComponents();
    }
    
    /**
     * Associates a wizard panel with this Swing panel.
     * This method should be called to initialize this panel.
     *
     * @param panel associated panel. 
     */
    public void setWizardPanel(SimpleWizardPanel panel) {
        this.panel = panel;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jFileChooser = new javax.swing.JFileChooser();

        setLayout(new java.awt.BorderLayout());

        setName(org.openide.util.NbBundle.getBundle(OpenFilePanel.class).getString("ChooseSource"));
        jFileChooser.setControlButtonsAreShown(false);
        jFileChooser.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                jFileChooserPropertyChange(evt);
            }
        });

        add(jFileChooser, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    private void jFileChooserPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_jFileChooserPropertyChange
        if (evt.getPropertyName() == JFileChooser.SELECTED_FILE_CHANGED_PROPERTY) {
            check();
        }
    }//GEN-LAST:event_jFileChooserPropertyChange
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JFileChooser jFileChooser;
    // End of variables declaration//GEN-END:variables
    
    /**
     * Returns the associated file chooser
     *
     * @return file chooser
     */
    public JFileChooser getFileChooser() {
        return jFileChooser;
    }

    /**
     * Sets choosed file
     *
     * @param f choosed file
     */
    public void setFile(File f) {
        jFileChooser.setSelectedFile(f);
        check();
    }
    
    /**
     * Returns selected file
     *
     * @return selected file or null
     */
    public File getFile() {
        return jFileChooser.getSelectedFile();
    }
    
    /**
     * Sets the valid property
     */
    private void check() {
        File f = jFileChooser.getSelectedFile();
        if (f == null) {
            panel.setErrorMessage(NbBundle.getMessage(
                OpenFilePanel.class, "EmptyFileName2")); // NOI18N
            return;
        }
        
        try {
            System.getSecurityManager().checkRead(f.getAbsolutePath());
            panel.setErrorMessage(null);
        } catch (SecurityException e) {
            panel.setErrorMessage(e.getLocalizedMessage());
        }
    }
}
