/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.core.export;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.tasklist.core.util.SimpleWizardPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 * Panel with a file chooser
 */
public class SaveFilePanel extends javax.swing.JPanel {
    private JFileChooser fc = new JFileChooser();
    private SimpleWizardPanel panel;
    
    /** Creates new form ChooseFilePanel */
    public SaveFilePanel() {
        initComponents();
        fc.setDialogType(JFileChooser.SAVE_DIALOG);
        jTextFieldFile.getDocument().addDocumentListener(
            new DocumentListener() {
                public void insertUpdate(DocumentEvent e) {
                    check();
                }
                public void removeUpdate(DocumentEvent e) {
                    check();
                }
                public void changedUpdate(DocumentEvent e) {
                    check();
                }
            }
        );
    }
    
    /**
     * Associates a wizard panel with this Swing panel.
     * This method should be called to initialize this panel.
     *
     * @param panel associated panel. 
     */
    public void setWizardPanel(SimpleWizardPanel panel) {
        this.panel = panel;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jTextFieldFile = new javax.swing.JTextField();
        jButtonChoose = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setName(org.openide.util.NbBundle.getBundle(SaveFilePanel.class).getString("ChooseFile"));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getBundle(SaveFilePanel.class).getString("File"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 12);
        add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 12);
        add(jTextFieldFile, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jButtonChoose, "...");
        jButtonChoose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonChooseActionPerformed(evt);
            }
        });

        add(jButtonChoose, new java.awt.GridBagConstraints());

    }//GEN-END:initComponents

    private void jButtonChooseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonChooseActionPerformed
        fc.setSelectedFile(new File(jTextFieldFile.getText()));
        if (fc.showSaveDialog(this) != JFileChooser.APPROVE_OPTION) 
            return;
        
        if (fc.getSelectedFile().exists()) {
            NotifyDescriptor nd = new NotifyDescriptor.Confirmation(
                NbBundle.getMessage(SaveFilePanel.class, 
                    "FileExistsOverwrite"), // NOI18N
                NbBundle.getMessage(SaveFilePanel.class, 
                    "Warning"), // NOI18N
                NotifyDescriptor.OK_CANCEL_OPTION);
            if (DialogDisplayer.getDefault().notify(nd) != 
            NotifyDescriptor.OK_OPTION) 
                return;
        }
        jTextFieldFile.setText(fc.getSelectedFile().getAbsolutePath()); 
    }//GEN-LAST:event_jButtonChooseActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonChoose;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JTextField jTextFieldFile;
    // End of variables declaration//GEN-END:variables
    
    /**
     * Returns the associated file chooser
     *
     * @return file chooser
     */
    public JFileChooser getFileChooser() {
        return fc;
    }

    /**
     * Sets choosed file
     *
     * @param f choosed file
     */
    public void setFile(File f) {
        jTextFieldFile.setText(f.getAbsolutePath());
        fc.setSelectedFile(f);
        check();
    }
    
    /**
     * Returns selected file
     *
     * @return selected file or null
     */
    public File getFile() {
        return new File(jTextFieldFile.getText());
    }
    
    /**
     * Sets the valid property
     */
    private void check() {
        String t = jTextFieldFile.getText().trim();
        if (t.length() == 0) {
            panel.setErrorMessage(NbBundle.getMessage(
                SaveFilePanel.class, "EmptyFileName")); // NOI18N
            return;
        }  
            
        File f = new File(t);
        if (f.isDirectory()) {
            panel.setErrorMessage(NbBundle.getMessage(
                SaveFilePanel.class, "NotAFile")); // NOI18N
            return;
        }
        
        File dir = f.getParentFile();
        if (dir == null || !dir.isDirectory()) {
            // Parent directory does not exist
            panel.setErrorMessage(NbBundle.getMessage(
                SaveFilePanel.class, "NoParent")); // NOI18N
            return;
        }
        
        if (!f.isAbsolute()) {
            panel.setErrorMessage(NbBundle.getMessage(
                SaveFilePanel.class, "NotAnAbsolutePath")); // NOI18N
            return;
        }        
        
        try {
            System.getSecurityManager().checkWrite(f.getAbsolutePath());
            panel.setErrorMessage(null);
        } catch (SecurityException e) {
            panel.setErrorMessage(e.getLocalizedMessage());
        }
    }
}
