/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.core.filter;

import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/**
 * Customizes hierarchy criteria (usefull for user tasks)
 *
 * @author  Petr Kuzel
 */
public class HierarchyFilterSubpanel extends javax.swing.JPanel implements FilterSubpanel {

    private static final long serialVersionUID = 1;

    /** Creates new form HiearchyFilterPanel */
    public HierarchyFilterSubpanel() {
        initComponents();

        Mnemonics.setLocalizedText(subtaskLabel, NbBundle.getMessage(
                FilterPanel.class, "CheckSubtasks")); // NOI18N
        Mnemonics.setLocalizedText(bothTasksRadio, NbBundle.getMessage(
                FilterPanel.class, "IncludeTask")); // NOI18N
        Mnemonics.setLocalizedText(onlySubtaskRadio, NbBundle.getMessage(
                FilterPanel.class, "IncludeSubtask")); // NOI18N
        
    }

    public void updateFilter(Filter filter) {
        filter.setFlattened(onlySubtaskRadio.isSelected());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonGroup1 = new javax.swing.ButtonGroup();
        subtaskLabel = new javax.swing.JLabel();
        bothTasksRadio = new javax.swing.JRadioButton();
        onlySubtaskRadio = new javax.swing.JRadioButton();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(0, 11, 0, 0)));
        subtaskLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("CheckSubtasks"));
        add(subtaskLabel);

        bothTasksRadio.setSelected(true);
        bothTasksRadio.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("IncludeTask"));
        buttonGroup1.add(bothTasksRadio);
        add(bothTasksRadio);

        onlySubtaskRadio.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("IncludeSubtask"));
        buttonGroup1.add(onlySubtaskRadio);
        add(onlySubtaskRadio);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton bothTasksRadio;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JRadioButton onlySubtaskRadio;
    private javax.swing.JLabel subtaskLabel;
    // End of variables declaration//GEN-END:variables
    
}
