/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.core.util;

/**
 * A list of objects in a tree.
 */
public class TreeNodeList extends ObjectList {
    /**
     * A callback method for traversing a tree.
     */
    public static interface Callback {
        /**
         * This method will be called for each child.
         *
         * @param obj an object from an ObjectList
         */
        public void process(Object obj);
    }
    
    private Owner owner;
    
    /**
     * Creates a new instance of TreeNodeList
     *
     * @param owner owner of this list or null
     */
    public TreeNodeList(Owner owner) {
        this.owner = owner;
    }

    public Owner getOwner() {
        return owner;
    }

    protected boolean hasListeners() {
        if (super.hasListeners())
            return true;
        
        if (owner instanceof ObjectList.Element) {
            return ((ObjectList.Element) owner).getParentList().hasListeners();
        }
        
        return false;
    }

    protected void fireEvent(Event e) {
        super.fireEvent(e);
        
        if (owner instanceof ObjectList.Element) {
            ((ObjectList.Element) owner).getParentList().fireEvent(e);
        }
    }
}
