/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.javadoc;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Iterator;
import java.lang.reflect.Modifier;

import org.openide.src.*;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataObject;
import java.util.EventListener;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;
import org.netbeans.modules.tasklist.client.SuggestionAgent;
import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.netbeans.modules.tasklist.javadoc.ext.JavaTagNames;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Utilities;

/**
 * This file has been shamelessly stolen from the javadoc module.
 * I at first plugged my tasklist functionality into the javadoc
 * module, but since I had to make a couple of modifications etc.
 * I figured that meant this functionality will have to be delivered
 * as a patch, which means few people will ever see it.
 * So for now, just replicate the code and make a few modifications
 * (for example, the old AutoCommenter creates Swing List models).
 * I have marked the places I changed with a pair of
 *
 * <p>
 * Specific changes made:
 * <ul>
 *  <li> Replaced ResourceUtils references with NbBundle direct calls
 *  <li> Added a resolution list (to parallel the errorList)
 *  which lists the specific errors fixed (where the strings are
 *  labelled FIX_ instead of ERR_).  
 *  (These were the errors preceeded by a checkOnly flag)
 * </ul>
 * <p> 
 * Original javadoc:
 * <p>
 * Contains static methods for generating default JavaDoc comments for
 * java data object hierarchy elements.
 *
 * Checks for Comment errors in JavaDataObjects
 *
 * @author Petr Hrebejk
 */
public final class AutoCommenter extends Object implements JavaTagNames {
    public static final int JDC_OK = 1;
    public static final int JDC_MISSING = 2;
    public static final int JDC_ERROR = 4;
    
    private ArrayList elements;
    private final DataObject dataObject;
    /** Utility field holding the PropertyChangeListener. */
    private AutoCommentChangeListener autoCommentChangeListener =  null;
    private SuggestionContext env;
    private SuggestionManager man;

    /**
     *
     * Creates Auto commenter for data objects. NOTE: Does NOT NOT NOT NOT
     * keep listening on the data objects etc.
     */
    public AutoCommenter(SuggestionManager man, DataObject dobj, SuggestionContext env ) {
        this.man = man;
        dataObject = dobj;
        this.env = env;
        elements = new ArrayList();
    }

    private void prepareListModel(ArrayList listModel, int mask, boolean pckg, int err_mask ) {
        Iterator it = elements.iterator();

        while( it.hasNext() ) {
            AutoCommenterElement el = (AutoCommenterElement)it.next();

            if ( acceptElement( el, mask, pckg, err_mask ) ) {
                listModel.add( el );
            }
        }
    }
    
    static boolean acceptElement(AutoCommenterElement el, int mask, boolean pckg, int err_mask ) {
        // Test whether the element is accepted by error mask
        if ((el.getErrorNumber() & err_mask) == 0)
            return false;

        // Test whether the element is accepted by access mask
        int access = JavaDocUtils.getEffectiveAccess((MemberElement)el.getSrcElement());
        if (access == 0) 
            return pckg;
        else 
            return (access & mask) > 0;
    }

    ArrayList prepareListModel( int mask, boolean pckg, int err_mask ) {
        ArrayList dm = new ArrayList();
        prepareListModel( dm, mask, pckg, err_mask );
        return dm;
    }

    private void addElements( ClassElement classElement ) {
        elements.add( new AutoCommenterClass( classElement ) );

        FieldElement[] fe = classElement.getFields();
        for( int i = 0; i < fe.length; i++ ) {
            elements.add( new AutoCommenterField ( fe[i] ) );
        }

        ConstructorElement[] ce = classElement.getConstructors();
        for( int i = 0; i < ce.length; i++ ) {
            elements.add( new AutoCommenterConstructor ( ce[i] ) );
        }

        MethodElement[] me = classElement.getMethods();
        for( int i = 0; i < me.length; i++ ) {
            elements.add( new AutoCommenterMethod ( me[i] ) );
        }

        /* getAllClasses is already recursive
        ClassElement[] ice = classElement.getClasses();
        for( int i = 0; i < ice.length; i++ ) {
          addElements( ice[i] );
    }
        */
    }
    
    public interface AutoCommentChangeListener extends EventListener {
        public void listChanged();
    }
    
    /** Registers PropertyChangeListener to receive events.
     * @param listener The listener to register.
     */
    public synchronized void addAutoCommentChangeListener(AutoCommentChangeListener listener) throws java.util.TooManyListenersException {
        if (autoCommentChangeListener != null) {
            throw new java.util.TooManyListenersException();
        }
        autoCommentChangeListener = listener;
    }
    
    /** Removes PropertyChangeListener from the list of listeners.
     * @param listener The listener to remove.
     */
    public synchronized void removeAutoCommentChangeListener(AutoCommentChangeListener listener) {
        autoCommentChangeListener = null;
    }
    
    public ArrayList findErrors() {
        SourceCookie sc = (SourceCookie)dataObject.getCookie(SourceCookie.class);
        
        // We end up showing this panel for non-javadoc areas as well,
        // such as Bundle.properties files. Make sure we only operate
        // on files we have SourceCookies for!
        if (sc == null) 
            return null;
       
        SourceElement se = sc.getSource();
        if ( se != null ) {
            ClassElement[] ces = se.getAllClasses();
            for( int j = 0; j < ces.length; j++ ){
                addElements( ces[j] );
            }
        }
       
        return findErrors_();
    }
    
    private ArrayList findErrors_() {
        ArrayList tasks = new ArrayList(30);

        assert false : "Reimplemented in tasklist.javadoc.ext package"; 
//        // check for Javadoc for API (protected & public)
//        int modifierMask = Modifier.PUBLIC | Modifier.PROTECTED;
//        int errorMask = AutoCommenter.JDC_ERROR | AutoCommenter.JDC_MISSING;
//        boolean bpackage = false;  // Modifier.PACKAGE
//
//        ArrayList model = prepareListModel(modifierMask, bpackage, errorMask);
//
//        int n = model.size();
//        for (int i = 0; i < n; i++) {
//            Object value = model.get(i);
//            final AutoCommenterElement element = (AutoCommenterElement)value;
//            if (element.getErrorNumber() ==
//                AutoCommenter.JDC_OK) {
//                continue;
//            }
//
//            SuggestionPerformer action = new JavaDocSuggestionPerformer(
//                element, env);
//
//            ArrayList m2 = element.getErrorList();
//            int m2n = m2.size();
//            for (int j = 0; j < m2n; j++) {
//                Object v2 = m2.get(j);
//                String summary = element.getSrcElement().getName() +
//                    ": " +  // NOI18N
//                    v2.toString();
//                MemberElement el = element.getSrcElement();
//                if ((el instanceof MethodElement) &&
//                    (inheritsJavadoc((MethodElement)el))) {
//                    continue;
//                }
//                SuggestionAgent s = man.createSuggestion(
//                    DocSuggester.TYPE, summary, null, this);
//
//                //LineCookie ck = el.getCookie
//                // TODO: get & add line position
//                // Line l = null;
//                //s.setLine(l);
//
//                SourceCookie.Editor editor =
//                    (SourceCookie.Editor)dataObject.getCookie(SourceCookie.Editor.class);
//                javax.swing.text.Element textElement = editor.sourceToText(el);
//                if (textElement != null) {
//                    StyledDocument document = editor.getDocument();
//                    if (document != null) {
//                        int offset = textElement.getStartOffset();
//                        int lineNumber = NbDocument.findLineNumber(document, offset);
//                        Line line = editor.getLineSet().getCurrent(lineNumber);
//                        s.setLine(line);
//                    }
//                }
//                /* Error checking - do something similar above
//                try {
//                    javax.swing.text.Element textElement =
//                        editor.sourceToText((Element)offendingObject);
//
//                    if (textElement != null)
//                        {
//                            StyledDocument document = findDocument(editor);
//
//                            if (document != null) {
//                                int offset = textElement.getStartOffset();
//                                line = NbDocument.findLineNumber(document,
//                                                                 offset) + 1;
//                                column = NbDocument.findLineColumn(document,
//                                                                   offset) + 1;
//                            }
//                        }
//                } catch (IllegalArgumentException iae) {
//                    // found an element which doesn't have source
//                    // just don't set up a line and column
//                }
//                */
//
//                if (element.isCorrectable()) {
//                    if (element.getErrorNumber() ==
//                        AutoCommenter.JDC_MISSING) {
//                        // isCorrectable() seems to lie. Missing javadocs
//                        // are never correctable.
//                        Image taskIcon = Utilities.loadImage("org/netbeans/modules/tasklist/javadoc/missing.gif"); // NOI18N
//                        s.setIcon(taskIcon);
//                    } else {
//                        Image taskIcon = Utilities.loadImage("org/netbeans/modules/tasklist/javadoc/fixable-error.gif"); // NOI18N
//                        s.setIcon(taskIcon);
//                        s.setAction(action);
//                    }
//                } else if (element.getErrorNumber() ==
//                           AutoCommenter.JDC_MISSING) {
//                    Image taskIcon = Utilities.loadImage("org/netbeans/modules/tasklist/javadoc/missing.gif"); // NOI18N
//                    s.setIcon(taskIcon);
//                }
//
//                tasks.add(s.getSuggestion());
//            }
//        }
        return tasks;
    }

    private boolean inheritsJavadoc(MethodElement method) {
        ClassElement cl = method.getDeclaringClass();
        if (cl == null) {
            return false;
        }
        MethodParameter[] params = method.getParameters();
        Type[] types = new Type[params.length];
        for (int i = 0; i < params.length; i++) {
            types[i] = params[i].getType();
        }
        boolean[] checkedObject = new boolean[] {false};
        boolean found = inheritsJavadoc(cl, method, method.getName(), types, checkedObject);
        return found;
    }

    private boolean inheritsJavadoc(ClassElement cl, MethodElement self,
                                    Identifier method, Type[] arguments,
                                    boolean[] checkedObject) {
        checkedObject[0] |= cl.getName().getFullName().equals("java.lang.Object"); // NOI18N

        // See if the class itself contains the given method
        MethodElement mel = cl.getMethod(method, arguments);
        if ((mel != null) && (mel != self)) {
            // Check to see if the method has javadoc
            JavaDoc javadoc = mel.getJavaDoc();
            if ((javadoc != null) && !javadoc.isEmpty()) {
                return true;
            }
        }

        // Check interfaces
        Identifier[] interfaces = cl.getInterfaces();
        for (int j = 0; j < interfaces.length; j++) {
            ClassElement icl = ClassElement.forName(interfaces[j].getFullName());
            if (icl == null) {
                continue;
            }
            boolean found = inheritsJavadoc(icl, self, method, arguments, checkedObject);
            if (found) {
                return true;
            }
        }

        // Check super class
        Identifier scli = cl.getSuperclass();
        if (scli == null && !checkedObject[0]) {
            scli = Identifier.create("java.lang.Object"); // NOI18N
        }
        if (scli != null) {
            ClassElement scl = ClassElement.forName(scli.getFullName());
            if (scl != null) {
                boolean found = inheritsJavadoc(scl, self, method, arguments, checkedObject);
                if (found) {
                    return true;
                }
            }
        }
        return false;
    }
}
