package org.netbeans.modules.tasklist.javadoc;

import org.openide.src.ClassElement;
import org.openide.src.ElementFormat;
import org.openide.src.JavaDoc;
import org.openide.src.SourceException;
import org.netbeans.modules.tasklist.javadoc.ext.JavaTagNames;

public class AutoCommenterClass extends AutoCommenterElement {
    private static final String[] NOT_PERMITTED_TAGS = {
        JavaTagNames.TAG_EXCEPTION,
        JavaTagNames.TAG_PARAM,
        JavaTagNames.TAG_RETURN,
        JavaTagNames.TAG_SERIAL,
        JavaTagNames.TAG_SERIALDATA,
        JavaTagNames.TAG_SERIALFIELD,
        JavaTagNames.TAG_THROWS,
    };

    private static final ElementFormat nameFormat = new ElementFormat( "{m} {C}" ); // NOI18N

    public AutoCommenterClass( ClassElement element ) {
        super( element );
    }

    String[] getNotPermittedTags() {
        return NOT_PERMITTED_TAGS;
    }

    boolean elementTagsOk() {
        boolean error = false;
        if (this.isMultipleTags(JavaTagNames.TAG_VERSION)) {
            error = true;
        }
        return !error;
    }

    void autoCorrect() throws SourceException {
        super.autoCorrect( getJavaDoc() );
    }

    boolean isCorrectable() {
        return super.isCorrectable();
    }

    String typeToString() {
        return ((ClassElement)srcElement).isInterface() ? "interface" : "class"; // NOI18N
    }

    JavaDoc getJavaDoc() {
        return ((ClassElement)srcElement).getJavaDoc();
    }

    ElementFormat getNameFormat () {
        return nameFormat;
    }
}
