package org.netbeans.modules.tasklist.javadoc;

import org.openide.src.ElementFormat;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.JavaDocTag;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.NbBundle;
import org.netbeans.modules.tasklist.javadoc.ext.JavaTagNames;

public class AutoCommenterMethod extends AutoCommenterConstructor {
    private static final ElementFormat nameFormat = new ElementFormat( "{m} {r} {n} ( {p} )" ); // NOI18N

    private static final String[] NOT_PERMITTED_TAGS = {
        JavaTagNames.TAG_AUTHOR,
        JavaTagNames.TAG_SERIAL,
        JavaTagNames.TAG_SERIALFIELD,
        JavaTagNames.TAG_VERSION
    };

    public AutoCommenterMethod( MethodElement element ) {
        super( element );
    }

    JavaDoc getJavaDoc() {
        return ((MethodElement)srcElement).getJavaDoc();
    }

    String typeToString() {
        return "method"; // NOI18N
    }

    String[] getNotPermittedTags() {
        return NOT_PERMITTED_TAGS;
    }

    boolean elementTagsOk() {
        boolean superOk = super.elementTagsOk();
        boolean retOk = checkReturnType( false );
        return !superOk ? false : retOk;
    }

    private boolean checkReturnType( boolean checkOnly ) {

        boolean retOk = true;

        Type ret = ((MethodElement)srcElement).getReturn();
        JavaDocTag[] retTags = ((MethodElement)srcElement).getJavaDoc().getTags( JavaTagNames.TAG_RETURN );

        if ( ret == Type.VOID && retTags.length > 0 ) {
            if ( checkOnly ) {
                return false;
            }
            errorList.add(NbBundle.getMessage(AutoCommenter.class, "ERR_ReturnForVoid" ) );  //NOI18N
            resolutionList.add(NbBundle.getMessage(AutoCommenter.class, "FIX_ReturnForVoid" ) );  //NOI18N
            retOk = false;
        }
        else if ( ret != Type.VOID && retTags.length <= 0 ) {
            if ( checkOnly ) {
                return false;
            }
            errorList.add(  NbBundle.getMessage(AutoCommenter.class, "ERR_NoReturn") );  //NOI18N
            resolutionList.add(NbBundle.getMessage(AutoCommenter.class, "FIX_NoReturn") );  //NOI18N
            retOk = false;
        } else if ( ret != Type.VOID && retTags.length > 1 ) {
            if ( checkOnly) {
                return false;
            }
            errorList.add( NbBundle.getMessage(AutoCommenter.class, "ERR_DuplicatedReturn") );   //NOI18N
            resolutionList.add(NbBundle.getMessage(AutoCommenter.class, "FIX_DuplicatedReturn") );   //NOI18N
            retOk = false;
        }

        return retOk;
    }


    boolean isCorrectable() {

        if ( super.isCorrectable() )
            return true;

        return !checkReturnType( true );
    }

    void autoCorrect() throws SourceException {
        JavaDoc jdTemp = JavaDocSupport.createMethodJavaDoc( getJavaDoc().getRawText() );
        super.autoCorrect( jdTemp );

        if (!checkReturnType( true ) ) {
            if ( ((MethodElement)srcElement).getReturn() != Type.VOID ) {
                jdTemp.changeTags(
                    new JavaDocTag[] { JavaDocSupport.createTag( JavaTagNames.TAG_RETURN, "" ) }, // NOI18N
                    JavaDoc.ADD );
            }
            else {
                JavaDocTag toRemove[] = jdTemp.getTags( JavaTagNames.TAG_RETURN );

                jdTemp.changeTags( toRemove, JavaDoc.REMOVE );
            }
        }

        getJavaDoc().setRawText( jdTemp.getRawText() );

    }

    ElementFormat getNameFormat () {
        return nameFormat;
    }
}

