package org.netbeans.modules.tasklist.javadoc;

import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.netbeans.modules.tasklist.javadoc.ext.JavadocProxy;
import org.openide.ErrorManager;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;

/**
 * Fixes JavaDoc errors
 */
public class JavaDocSuggestionPerformer implements SuggestionPerformer {
    private SuggestionContext env;
    private JavadocProxy.ElementProxy element;
    
    /**
     * Constructor
     *
     * @param element JavaDoc element
     * @param env a suggestion context
     */
    public JavaDocSuggestionPerformer(JavadocProxy.ElementProxy element,
    SuggestionContext env) {
        this.element = element;
        this.env = env;        
    }
    
    public boolean hasConfirmation() {
        return true;
    }
    
    public Object getConfirmation(Suggestion s) {
        String filename =
            env.getFileObject().getNameExt();

        StringBuffer sb = new StringBuffer(1000);
        sb.append("<html><body><ul>"); // NOI18N
        List resolutionList = element.getResolutionList();
        Iterator it = resolutionList.iterator();
        while (it.hasNext()) {
            String resolution = it.next().toString();
            sb.append("<li>"); // NOI18N
            TLUtils.appendHTMLString(sb, resolution);
        }
        sb.append("</ul></body></html>"); // NOI18N
        String afterContents = sb.toString();

        String beforeDesc = NbBundle.getMessage(
            JavaDocSuggestionPerformer.class, "ConfPanelAbove"); // NOI18N
        sb.setLength(0);
        sb.append("<html><body><i>/** "); // NOI18N
        TLUtils.appendHTMLString(
            sb,element.getJavaDoc().getRawText());
        sb.append("*/</i></body></html>"); // NOI18N
        String beforeContents = sb.toString();
        String afterDesc = NbBundle.getMessage(
            DocSuggester.class, "ConfPanelBelow"); // NOI18N
        
        return new ConfPanel(beforeDesc, beforeContents,
                             afterDesc, 
                             afterContents, filename, -1);

    }
    
    public void perform(Suggestion s) {
        element.viewSource(); // Check later
        try {
            element.autoCorrect();
        } catch (SourceException e) {
            ErrorManager.getDefault().notify(e);
        }
    }
};
