/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.javadoc.ext;

import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.netbeans.modules.tasklist.javadoc.*;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;
import org.netbeans.modules.tasklist.client.SuggestionAgent;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.openide.cookies.SourceCookie;
import org.openide.src.*;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.text.Line;
import org.openide.util.Utilities;

import javax.swing.text.StyledDocument;
import javax.swing.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Collections;
import java.lang.reflect.Modifier;
import java.awt.*;

/**
 * Entry point to copied functionality
 * 
 * @author Petr Kuzel
 */
public final class JavadocProxy {

    public static List findErrors(SuggestionContext env) {

        DataObject dobj = null;
        try {
            dobj = DataObject.find(env.getFileObject());
        } catch (DataObjectNotFoundException e) {
            return null;
        }
        SourceCookie sc = (SourceCookie)dobj.getCookie(SourceCookie.class);

        // We end up showing this panel for non-javadoc areas as well,
        // such as Bundle.properties files. Make sure we only operate
        // on files we have SourceCookies for!
        if (sc == null)
            return null;

        AutoCommenter peer = new AutoCommenter();
        peer.elements = new ArrayList();

        SourceElement se = sc.getSource();
        if ( se != null ) {
            ClassElement[] ces = se.getAllClasses();
            for( int j = 0; j < ces.length; j++ ){
                peer.addElements( ces[j] );
            }
        }

        ArrayList tasks = new ArrayList(30);

        // check for Javadoc for API (protected & public)
        int modifierMask = Modifier.PUBLIC | Modifier.PROTECTED;
        int errorMask = AutoCommenter.JDC_ERROR | AutoCommenter.JDC_MISSING;
        boolean bpackage = false;  // Modifier.PACKAGE

        DefaultListModel model = peer.prepareListModel(modifierMask, bpackage, errorMask);

        int n = model.size();
        for (int i = 0; i < n; i++) {
            Object value = model.get(i);
            final AutoCommenter.Element element = (AutoCommenter.Element)value;
            if (element.getErrorNumber() ==
                AutoCommenter.JDC_OK) {
                continue;
            }

            SuggestionPerformer action = new JavaDocSuggestionPerformer(
                new ElementProxy(element), env
            );

            DefaultListModel m2 = element.getErrorList();
            int m2n = m2.size();
            for (int j = 0; j < m2n; j++) {
                Object v2 = m2.get(j);
                String summary = element.getSrcElement().getName() +
                    ": " +  // NOI18N
                    v2.toString();

                MemberElement el = element.getSrcElement();
// TODO what's this
//                if ((el instanceof MethodElement) &&
//                    (inheritsJavadoc((MethodElement)el))) {
//                    continue;
//                }
                SuggestionAgent s = SuggestionManager.getDefault().createSuggestion(
                    DocSuggester.TYPE, summary, null, DocSuggester.TYPE);

                //LineCookie ck = el.getCookie
                // TODO: get & add line position
                // Line l = null;
                //s.setLine(l);

                SourceCookie.Editor editor =
                    (SourceCookie.Editor)dobj.getCookie(SourceCookie.Editor.class);
                javax.swing.text.Element textElement = editor.sourceToText(el);
                if (textElement != null) {
                    StyledDocument document = editor.getDocument();
                    if (document != null) {
                        int offset = textElement.getStartOffset();
                        int lineNumber = NbDocument.findLineNumber(document, offset);
                        Line line = editor.getLineSet().getCurrent(lineNumber);
                        s.setLine(line);
                    }
                }
                /* Error checking - do something similar above
                try {
                    javax.swing.text.Element textElement =
                        editor.sourceToText((Element)offendingObject);

                    if (textElement != null)
                        {
                            StyledDocument document = findDocument(editor);

                            if (document != null) {
                                int offset = textElement.getStartOffset();
                                line = NbDocument.findLineNumber(document,
                                                                 offset) + 1;
                                column = NbDocument.findLineColumn(document,
                                                                   offset) + 1;
                            }
                        }
                } catch (IllegalArgumentException iae) {
                    // found an element which doesn't have source
                    // just don't set up a line and column
                }
                */

                if (element.isCorrectable()) {
                    if (element.getErrorNumber() ==
                        AutoCommenter.JDC_MISSING) {
                        // isCorrectable() seems to lie. Missing javadocs
                        // are never correctable.
                        Image taskIcon = Utilities.loadImage("org/netbeans/modules/tasklist/javadoc/missing.gif"); // NOI18N
                        s.setIcon(taskIcon);
                    } else {
                        Image taskIcon = Utilities.loadImage("org/netbeans/modules/tasklist/javadoc/fixable-error.gif"); // NOI18N
                        s.setIcon(taskIcon);
                        s.setAction(action);
                    }
                } else if (element.getErrorNumber() ==
                           AutoCommenter.JDC_MISSING) {
                    Image taskIcon = Utilities.loadImage("org/netbeans/modules/tasklist/javadoc/missing.gif"); // NOI18N
                    s.setIcon(taskIcon);
                }

                tasks.add(s.getSuggestion());
            }
        }
        return tasks;

    }

    public static class ElementProxy {

        private AutoCommenter.Element peer;

        public ElementProxy(AutoCommenter.Element peer) {
            this.peer = peer;
        }

        /** List of human readable resolutions. */
        public List getResolutionList() {
            // TODO extract from the old omplementation
            return Collections.EMPTY_LIST;
        }

        public JavaDoc getJavaDoc() {
            return peer.getJavaDoc();
        }

        public void viewSource() {
            peer.viewSource();
        }

        public void autoCorrect() throws SourceException {
            peer.autoCorrect();
        }

    }


//    private boolean inheritsJavadoc(MethodElement method) {
//        ClassElement cl = method.getDeclaringClass();
//        if (cl == null) {
//            return false;
//        }
//        MethodParameter[] params = method.getParameters();
//        Type[] types = new Type[params.length];
//        for (int i = 0; i < params.length; i++) {
//            types[i] = params[i].getType();
//        }
//        boolean[] checkedObject = new boolean[] {false};
//        boolean found = inheritsJavadoc(cl, method, method.getName(), types, checkedObject);
//        return found;
//    }
//
//    private boolean inheritsJavadoc(ClassElement cl, MethodElement self,
//                                    Identifier method, Type[] arguments,
//                                    boolean[] checkedObject) {
//        checkedObject[0] |= cl.getName().getFullName().equals("java.lang.Object"); // NOI18N
//
//        // See if the class itself contains the given method
//        MethodElement mel = cl.getMethod(method, arguments);
//        if ((mel != null) && (mel != self)) {
//            // Check to see if the method has javadoc
//            JavaDoc javadoc = mel.getJavaDoc();
//            if ((javadoc != null) && !javadoc.isEmpty()) {
//                return true;
//            }
//        }
//
//        // Check interfaces
//        Identifier[] interfaces = cl.getInterfaces();
//        for (int j = 0; j < interfaces.length; j++) {
//            ClassElement icl = ClassElement.forName(interfaces[j].getFullName());
//            if (icl == null) {
//                continue;
//            }
//            boolean found = inheritsJavadoc(icl, self, method, arguments, checkedObject);
//            if (found) {
//                return true;
//            }
//        }
//
//        // Check super class
//        Identifier scli = cl.getSuperclass();
//        if (scli == null && !checkedObject[0]) {
//            scli = Identifier.create("java.lang.Object"); // NOI18N
//        }
//        if (scli != null) {
//            ClassElement scl = ClassElement.forName(scli.getFullName());
//            if (scl != null) {
//                boolean found = inheritsJavadoc(scl, self, method, arguments, checkedObject);
//                if (found) {
//                    return true;
//                }
//            }
//        }
//        return false;
//    }

}
